const traverse = require('mdast-util-to-bemjson/lib/traverse');

module.exports = function(transform, node, parent) {
    const props = {
        'wiki-attrs': {
            level: node.depth,
            section_local: node.section_local,
            anchor: node.anchor,
            text: node.text,
        },
        mods: {
            expandable: node.expandable,
            md: node.type === 'heading',
        },
    };

    if (node.expandable && !node.visited) {
        let start;
        for (let i = 0; i < parent.children.length; i++) {
            if (parent.children[i] === node) {
                start = i + 1;
                break;
            }
        }

        const children = [];
        for (let i = start; i < parent.children.length; i++) {
            if (
                parent.children[i].type.toLowerCase().includes('heading') &&
                parent.children[i].depth <= node.depth
            ) {
                break;
            }
            children.push(Object.assign({}, parent.children[i]));
            parent.children[i] = { type: 'text', value: '' };
        }
        node.visited = true;

        const headcut = {
            type: 'womCut',
            title: [node],
            heading: true,
            children: children,
        };

        return traverse(transform, headcut, parent);
    }

    return transform(node, 'wiki-head', props);
};
