const { getClient, getOrigin } = require('../utils/client');
const { LruCache } = require('../utils/lru-cache');
const DELIMITER = '\u0080';
const buffer = [];
const cache = new LruCache(1024);

let promise = Promise.resolve([]);

async function sanitizeHtml(html, { fetchAction }) {
    const index = buffer.push(html) - 1;

    if (index === 0) {
        // Первый элемент в буффере, начинаем фетчить через тик,
        // пока идет тик, могут прилететь другие асинхронные вызовы
        promise = new Promise((accept, reject) => {
            setTimeout(() => {
                // Тик прошел, клонируем буфер
                const html = buffer.join(DELIMITER);

                // Очищаем статический буффер
                buffer.length = 0;

                let request = cache.get(html);

                if (!request) {
                    request = fetchAction('sanitizer', {
                        html,
                        _$client: getClient(),
                        _$origin: getOrigin(),
                    });

                    cache.set(html, request);
                }

                request
                    .then(result => result.split(DELIMITER))
                    .then(accept, reject);
            }, 0);
        });
    }

    return promise.then(results => results[index]);
}

module.exports = ({ promises, ...settings }) => (transform, node) => {
    const props = { 'wiki-attrs': {} };
    const res = transform(node, 'wiki-sanitizer', props);

    promises.push(
        sanitizeHtml(node.value, settings).then(
            result => {
                res.html = result;
            },
            reason => {
                res.error = reason;
            }
        )
    );

    return res;
};
