module.exports = function(transform, node) {
    const wikiAttrs = {
        multiline: node.children && node.children.length > 1,
    };

    for (let attr in node.attributes) {
        wikiAttrs[attr.replace(/^wrapper_/, '')] = node.attributes[attr];
    }

    const props = {
        'wiki-attrs': wikiAttrs,
        mods: {
            format: node.format,
        }
    };

    return transform(node, 'wiki-formatter', props);
};
