module.exports = function(transform, node) {
    const props = {
        'wiki-attrs': {
            login: node.value,
            case: node.case,
        },
    };

    if (node.at === null) {
        props.mods = { magiclink: 'yes' };
    } else {
        props['wiki-attrs'].name = node.at === 'suffix' ? `${node.value}@` : `@${node.value}`;
        props['wiki-attrs'].at = node.at;
    }

    return transform(node, 'wiki-staff', props);
};
