module.exports = function(transform, node) {
    const maxRowLength = Math.max.apply(null, node.children.map(row => row.children.length));

    node.children.forEach(row => {
        row.maxRowLength = maxRowLength;
    });

    const props = {};

    if (node.kind === 'layout') {
        props['wiki-attrs'] = {
            type: 'wide',
        };
    }

    return transform(node, 'wiki-table', props);
};
