const traverse = require('mdast-util-to-bemjson/lib/traverse');

function revert(transform, node) {
    let subtype = node.referenceType;
    let suffix = ']';
    let contents;
    let head;
    let tail;

    if (subtype === 'collapsed') {
        suffix += '[]';
    } else if (subtype === 'full') {
        suffix += '[' + node.identifier + ']';
    }

    if (node.type === 'imageReference') {
        return node.alt ? '![' + node.alt + suffix : '![' + suffix;
    }

    contents = node.children;
    head = contents[0];

    if (head && head.type === 'text') {
        head.value = '[' + head.value;
    } else {
        contents.unshift({ type: 'text', value: '[' });
    }

    tail = contents[contents.length - 1];

    if (tail && tail.type === 'text') {
        tail.value += suffix;
    } else {
        contents.push({ type: 'text', value: suffix });
    }

    return traverse.children(transform, node);
}

module.exports = revert;
