const visit = require('unist-util-visit');

const config = require('./sanitizer-config');

// Check whether `value` is a safe URL.
function handleProtocol(type, value) {
    const protocols = config.protocols[type];

    if (!protocols || protocols.length === 0) {
        return true;
    }

    value = String(value);
    const first = value.charAt(0);

    // Относительные ссылки всегда безопасны
    if (first === '#' || first === '/') {
        return true;
    }

    const colon = value.indexOf(':');

    // Нет протокола – нет проблем
    if (colon === -1) {
        return true;
    }

    const length = protocols.length;
    let index = -1;

    while (++index < length) {
        const protocol = protocols[index];

        if (
            colon === protocol.length &&
            value.slice(0, protocol.length).toLowerCase() === protocol
        ) {
            return true;
        }
    }

    index = value.indexOf('?');

    if (index !== -1 && colon > index) {
        return true;
    }

    index = value.indexOf('#');

    if (index !== -1 && colon > index) {
        return true;
    }

    return false;
}

const urlHandler = node => {
    if (!node.type) {
        return node;
    }

    const type = node.type.replace('wom', '').toLowerCase();

    if (handleProtocol(type, node.url)) {
        return node;
    }

    node.url = '#sanitized';
    return node;
};

function transformer(ast) {
    visit(ast, node => node.url, urlHandler);
}

function slug() {
    return transformer;
}

module.exports = slug;
