/* eslint-disable quote-props */
const macroses = {
    'вики': 'wiki',
    'вако': 'wacko',
    'вака': 'shwacko',
    'веб': 'web',
    'ланс': 'lance',
    'кукуц': 'kukutz',
    'мендокуси': 'mendokusee',
    'яремко': 'iaremko',
    'николай': 'nikolai',
    'алексей': 'aleksey',
    'анатолий': 'anatoly',
};
/* eslint-enable quote-props */

const singleCharLettersFrom = ['а', 'б', 'в', 'г', 'д', 'е', 'з', 'и', 'к', 'л', 'м', 'н', 'о', 'п',
    'р', 'с', 'т', 'у', 'ф', 'х', 'ъ', 'ь', 'ц', 'ы',
    'А', 'Б', 'В', 'Г', 'Д', 'Е', 'З', 'И', 'К', 'Л',
    'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ъ', 'Ь', 'Ц', 'Ы'];
const singleCharLettersTo = ['a', 'b', 'v', 'g', 'd', 'e', 'z', 'i', 'k', 'l', 'm',
    'n', 'o', 'p', 'r', 's', 't', 'u', 'f', 'x', '',
    '', 'c', 'y', 'A', 'B', 'V', 'G', 'D', 'E', 'Z', 'I',
    'K', 'L', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'U', 'F',
    'X', '', '', 'C', 'Y'];
const DoubleCharLettersFrom = ['й', 'ё', 'ж', 'ч', 'ш', 'щ', 'э', 'ю', 'я', 'Й',
    'Ё', 'Ж', 'Ч', 'Ш', 'Щ', 'Э', 'Ю', 'Я'];
const DoubleCharLettersTo = ['jj', 'jo', 'zh', 'ch', 'sh', 'shh', 'je',
    'ju', 'ja', 'Jj', 'Jo', 'Zh', 'Ch', 'Sh', 'Shh', 'Je', 'Ju', 'Ja'];

module.exports = (word = '') => {
    for (let macrosKey in macroses) {
        word = word.replace(new RegExp(macrosKey, 'ig'), macroses[macrosKey].toUpperCase());
    }

    singleCharLettersFrom.forEach((char, i) => {
        word = word.replace(new RegExp(char, 'g'), singleCharLettersTo[i]);
    });
    DoubleCharLettersFrom.forEach((char, i) => {
        word = word.replace(new RegExp(char, 'g'), DoubleCharLettersTo[i]);
    });

    word = word
        .replace(/[^A-Za-z0-9./-]/g, '')
        .replace(/^\.+/g, '')
        .replace(/\.+$/g, '');

    return word.toLowerCase();
};
