function getFieldOrigin() {
    if (process.env.BROWSER) {
        return window.location.origin;
    }

    return require('os').hostname();
}

function getFieldClient() {
    if (process.env.BROWSER) {
        return `@yandex-int/woof@${JSON.parse(process.env.VERSION)}`;
    }

    const { name, version } = require('../../package');

    return `${name}@${version}`;
}

exports.getOrigin = getFieldOrigin;
exports.getClient = getFieldClient;
