# character-entities-html4

[![Build][build-badge]][build]
[![Downloads][downloads-badge]][downloads]
[![Size][size-badge]][size]

HTML4 character entity information.

## Installation

[npm][]:

```bash
npm install character-entities-html4
```

## Usage

```js
var characterEntities = require('character-entities-html4')

console.log(characterEntities.AElig) // => 'Æ'
console.log(characterEntities.aelig) // => 'æ'
console.log(characterEntities.amp) // => '&'
console.log(characterEntities.apos) // => undefined
```

## API

### `characterEntitiesHTML4`

Mapping between (case-sensitive) character entity names to replacements.

## Support

See [w3.org][html].

## Related

*   [`character-entities`](https://github.com/wooorm/character-entities)
    — HTML character entity info
*   [`character-entities-legacy`](https://github.com/wooorm/character-entities-legacy)
    — Legacy character entity info
*   [`parse-entities`](https://github.com/wooorm/parse-entities)
    — Parse HTML character references
*   [`stringify-entities`](https://github.com/wooorm/stringify-entities)
    — Stringify HTML character references

## License

[MIT][license] © [Titus Wormer][author]

<!-- Definitions -->

[build-badge]: https://img.shields.io/travis/wooorm/character-entities-html4.svg

[build]: https://travis-ci.org/wooorm/character-entities-html4

[downloads-badge]: https://img.shields.io/npm/dm/character-entities-html4.svg

[downloads]: https://www.npmjs.com/package/character-entities-html4

[size-badge]: https://img.shields.io/bundlephobia/minzip/character-entities-html4.svg

[size]: https://bundlephobia.com/result?p=character-entities-html4

[npm]: https://docs.npmjs.com/cli/install

[license]: license

[author]: https://wooorm.com

[html]: https://www.w3.org/TR/html4/sgml/entities.html
