export interface IPluralForms {
    one: string;
    some: string;
    many?: string;
    none?: string;
}
export declare type KeysetKey = string | IPluralForms;
export declare type Keyset = Record<string, KeysetKey>;
export declare type KeysetDictionary = Record<string, Keyset>;
export declare type I18nBaseOptions = Record<string, string | object | number | undefined>;
export declare type I18nPluralOptions = I18nBaseOptions & {
    count: number;
};
export declare type I18nOptions = I18nBaseOptions | I18nPluralOptions;
export declare type I18nRaw = Array<string | object | number | undefined>;
export declare type Language = 'be' | 'en' | 'kk' | 'ru' | 'tr' | 'tt' | 'uk' | 'id' | 'uz';
export declare type PluralFunction = (count: number, params: IPluralForms) => string;
export declare type PluralMap = Record<Language, PluralFunction>;
export default function i18n(keyset: KeysetDictionary): (key: string, options?: I18nOptions) => string;
export declare function i18nRaw(keyset: KeysetDictionary): (key: string, options?: I18nOptions) => (string | number | object | undefined)[];
export declare function setI18nLang(lang: Language): void;
export declare function getI18nLang(): Language;
export declare function resolveI18nLang(languages: string[], requestLang: Language, requestTld: string): Language;
