"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var be_1 = require("./plural/be");
var en_1 = require("./plural/en");
var id_1 = require("./plural/id");
var kk_1 = require("./plural/kk");
var ru_1 = require("./plural/ru");
var tr_1 = require("./plural/tr");
var tt_1 = require("./plural/tt");
var uk_1 = require("./plural/uk");
var uz_1 = require("./plural/uz");
var pluralMap = {
    be: be_1.default,
    en: en_1.default,
    id: id_1.default,
    kk: kk_1.default,
    ru: ru_1.default,
    tr: tr_1.default,
    tt: tt_1.default,
    uk: uk_1.default,
    uz: uz_1.default,
};
var _lang = 'ru';
var _defLang = 'ru';
function getDefLang(lang) {
    return ['tr', 'id', 'fi', 'lt', 'pl', 'et', 'lv'].indexOf(lang) === -1 ? 'ru' : 'en';
}
function generateText(template, options) {
    var res = [];
    var len = template.length;
    var pos = 0;
    while (pos < len) {
        var p1 = template.indexOf('{', pos);
        if (p1 === -1) {
            res.push(template.substring(pos));
            return res;
        }
        var p2 = template.indexOf('}', p1);
        if (p2 === -1) {
            res.push(template.substring(pos));
            return res;
        }
        res.push(template.substring(pos, p1), options[template.substring(p1 + 1, p2)]);
        pos = p2 + 1;
    }
    return res;
}
function generateTextWithPlural(plural, options) {
    var pluralizer = pluralMap[_lang] || pluralMap[_defLang];
    var template = pluralizer(options.count, plural);
    return generateText(template, options);
}
function _i18n(keyset, key, options) {
    if (options === void 0) { options = {}; }
    var keysetKey = (keyset[_lang] && keyset[_lang][key]) || keyset[_defLang][key] || keyset.ru[key];
    if (typeof keysetKey === 'string') {
        return generateText(keysetKey, options);
    }
    else if (keysetKey) {
        return generateTextWithPlural(keysetKey, options);
    }
    return [key];
}
function i18n(keyset) {
    return function (key, options) {
        if (options === void 0) { options = {}; }
        return _i18n(keyset, key, options).join('');
    };
}
exports.default = i18n;
function i18nRaw(keyset) {
    return function (key, options) {
        if (options === void 0) { options = {}; }
        return _i18n(keyset, key, options);
    };
}
exports.i18nRaw = i18nRaw;
function setI18nLang(lang) {
    _lang = lang;
    _defLang = getDefLang(lang);
}
exports.setI18nLang = setI18nLang;
function getI18nLang() {
    return _lang;
}
exports.getI18nLang = getI18nLang;
function resolveI18nLang(languages, requestLang, requestTld) {
    var language = requestLang;
    if (languages.indexOf(language) === -1) {
        switch (requestTld) {
            case 'com':
                language = 'en';
                break;
            case 'com.tr':
                language = 'tr';
                break;
            default:
                language = 'ru';
        }
    }
    return language;
}
exports.resolveI18nLang = resolveI18nLang;
