const serpDispatcher = require('tanker-kit/ext/dispatchers/json2bem_serp');
const { I18nKeysetHandler, I18nKeysetHandlerStorage } = require('./ts-keyset');

module.exports = function(arg) {
    /**
     * в i18nKeysets приходит объект вида:
     * {
     *   "src/Foo/Foo.server.tsx-i18n/ru.js": "module.exports = { "Foo": { ... } };",
     *   ...
     * }
     */
    return serpDispatcher(arg).then(i18nKeysets => {
        const oldI8n = {};
        const newI18n = new I18nKeysetHandlerStorage();

        for (const [filePath, fileContent] of Object.entries(i18nKeysets)) {
            if (!filePath.includes('tsx-i18n') && !filePath.includes('ts-i18n')) {
                oldI8n[filePath] = fileContent;
                continue;
            }

            newI18n.add(new I18nKeysetHandler(filePath, fileContent));
        }

        return { ...oldI8n, ...newI18n.getFiles() };
    });
};
