const path = require('path');

const taburetDispatcher = require.resolve('@yandex-int/tanker-helpers/dispatchers/ts_dispatcher.js');
const tsParser = require.resolve('@yandex-int/tanker-helpers/parsers/ts_parser.js');

// https://github.yandex-team.ru/lego/tanker-kit/blob/dev/doc/overview.md#Структура-конфига

module.exports = function(config) {

    const levels = [
        'src/components/'
    ];

    // ID проекта в танкере
    config.tanker.project = 'serptest';

    // Shell-команды, где и что искать
    config.finders = [
        // Найти все ts-файлы, исключить из списка:
        // - файлы находящиеся в папках  и *.i18n/
        'find ' +
        levels.join(' ') +
        ' -name "*.tsx" -o -name "*.ts" -type f | grep -vE "/*\.i18n"'
    ];

    config.parsers.ts = tsParser;
    config.parsers.tsx = tsParser;

    config.dispatchers.json = taburetDispatcher;

    config.bemDispatcher = {
        levelResolver: filePath => {
            if (/^(src\/components)\//.test(filePath)) {
                // Необходимо подменить путь иначе файл сгенериться не там где нужно =(
                return path.dirname(filePath).split('/').slice(0, 2).join('/');
            }
        }
    };
};
