import { Block } from 'bem-react-core';

/** Импортируем модуль интернализации */
import i18n from '@yandex-int/i18n';

/** Импортируем локализационные ключи компонента */
import * as keyset from './link.i18n';

/** Создаём ф-ию интернализации нашего компонента */
const linkI18N = i18n(keyset);

export interface ILinkProps {
    text?: string;
}

export default class Link extends Block<ILinkProps> {
    block = 'link';

    protected content() {
        const { text } = this.props;
        if (text) { return text }

        /** Использование i18n */
        return linkI18N('show all');
    }

    protected tag() {
        return 'a';
    }

    protected attrs() {
        return { url: 'https://ya.ru' };
    }

    protected mods() {
        const { theme, size } = this.props;
        return { theme, size };
    }
}
