// копипаста из парсера bem_serp с заменой bem.js на tanker-ts-i18n
const path = require('path');

const i18n = require('@yandex-int/tanker-ts-i18n');
const util = require('tanker-kit/ext/lib/util');

const isString = a => typeof a === 'string';
const LIGHT_CHECK = /i18n/;

module.exports = function(arg) {
    /**
     * в arg приходит объект вида
     * {
     *     data: 'контент файла',
     *     path: 'путь к файлу отоносительно .tanker',
     *     type: 'priv.js, js и тп'
     * }
     */

    if (!LIGHT_CHECK.test(arg.data)) {
        return [];
    }

    const content = arg.data;
    const filePath = arg.path;

    const keys = i18n.extractI18NKeysFromSourceCode(
        content,
        '@yandex-int/i18n',
        'i18n',
        path.basename(filePath)
    );

    return keys.map(key => {
        const { name, fragment, range, location, keyset, params, context } = key;

        const keyAdapter = {
            type: 'bem',
            hash: util.getHash(key, filePath),
            path: filePath,
            fragment: fragment,
            range: range,
            location: [location.line, location.column],
            upload: null,
            single: (isString(keyset) && isString(name)) || null,
            keyset: isString(keyset) ? keyset : null,
            key: isString(name) ? name : null,
            value: null,
            comment: '', // Никто больше не использует это поле
            context: context || '',
            plural: null,
            params: Array.isArray(params) ? params.reduce(function(acc, param) {
                return Object.assign({}, acc, param);
            }, {}) : false,
        };

        return { key: keyAdapter, _key: key };
    }).map(({ key, _key }) => {
        const params = key.params || {};

        // Если ID ключа на английском:
        // - не выгружать в Танкер
        // - не считать, что ID как-то связано со значением ключа
        //
        // Если ID ключа не на английском:
        // - Сделать значение ключа равным ID
        if (isString(key.key) && /^[\w-]+$/.test(key.key)) {
            key.upload = false;
        } else {
            key.value = key.key;
        }

        // Если в параметрах ключа есть поля 'some', 'many' или 'none':
        // - Считать ключ склоняемым
        // - Считать первой формой склонения значение ключа, определенное выше
        // - Вторую и третью берем из параметров some и many соответственно
        // - В русском языке "четвертая форма" всегда равна третьей
        if (params.some || params.many || params.none) {
            key.plural = true;
            key.value = [
                key.value,
                params.some || null,
                params.many || null,
                params.none || params.many || null,
            ];
            key.params = false;
        } else {
            key.plural = false;
        }

        if (key.context) {
            key.params = { context: key.context };
        }

        return key;
    });
};
