var statuses = {
	"100": "Continue",
	"101": "Switching Protocols",
	"102": "Processing",
	"103": "Early Hints",
	"200": "OK",
	"201": "Created",
	"202": "Accepted",
	"203": "Non-Authoritative Information",
	"204": "No Content",
	"205": "Reset Content",
	"206": "Partial Content",
	"207": "Multi-Status",
	"208": "Already Reported",
	"226": "IM Used",
	"300": "Multiple Choices",
	"301": "Moved Permanently",
	"302": "Found",
	"303": "See Other",
	"304": "Not Modified",
	"305": "Use Proxy",
	"307": "Temporary Redirect",
	"308": "Permanent Redirect",
	"400": "Bad Request",
	"401": "Unauthorized",
	"402": "Payment Required",
	"403": "Forbidden",
	"404": "Not Found",
	"405": "Method Not Allowed",
	"406": "Not Acceptable",
	"407": "Proxy Authentication Required",
	"408": "Request Timeout",
	"409": "Conflict",
	"410": "Gone",
	"411": "Length Required",
	"412": "Precondition Failed",
	"413": "Payload Too Large",
	"414": "URI Too Long",
	"415": "Unsupported Media Type",
	"416": "Range Not Satisfiable",
	"417": "Expectation Failed",
	"418": "I'm a Teapot",
	"421": "Misdirected Request",
	"422": "Unprocessable Entity",
	"423": "Locked",
	"424": "Failed Dependency",
	"425": "Too Early",
	"426": "Upgrade Required",
	"428": "Precondition Required",
	"429": "Too Many Requests",
	"431": "Request Header Fields Too Large",
	"451": "Unavailable For Legal Reasons",
	"500": "Internal Server Error",
	"501": "Not Implemented",
	"502": "Bad Gateway",
	"503": "Service Unavailable",
	"504": "Gateway Timeout",
	"505": "HTTP Version Not Supported",
	"506": "Variant Also Negotiates",
	"507": "Insufficient Storage",
	"508": "Loop Detected",
	"509": "Bandwidth Limit Exceeded",
	"510": "Not Extended",
	"511": "Network Authentication Required"
};

/**
 * Sets a response status code and text.
 * @example
 * res(ctx.status(301))
 * res(ctx.status(400, 'Custom status text'))
 * @see {@link https://mswjs.io/docs/api/context/status `ctx.status()`}
 */
const status = (statusCode, statusText) => {
    return (res) => {
        res.status = statusCode;
        res.statusText =
            statusText || statuses[String(statusCode)];
        return res;
    };
};

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function createCommonjsModule(fn, basedir, module) {
	return module = {
		path: basedir,
		exports: {},
		require: function (path, base) {
			return commonjsRequire(path, (base === undefined || base === null) ? module.path : base);
		}
	}, fn(module, module.exports), module.exports;
}

function commonjsRequire () {
	throw new Error('Dynamic requires are not currently supported by @rollup/plugin-commonjs');
}

var Headers_1 = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports, "__esModule", { value: true });
var HEADERS_INVALID_CHARACTERS = /[^a-z0-9\-#$%&'*+.^_`|~]/i;
var Headers = /** @class */ (function () {
    function Headers(headers) {
        var _this = this;
        this.map = {};
        if ((headers === null || headers === void 0 ? void 0 : headers.constructor.name) === 'Headers') {
            headers.forEach(function (value, name) {
                _this.append(name, value);
            }, this);
        }
        else if (Array.isArray(headers)) {
            headers.forEach(function (_a) {
                var name = _a[0], value = _a[1];
                _this.append(name, Array.isArray(value) ? value.join(', ') : value);
            });
        }
        else if (headers) {
            Object.getOwnPropertyNames(headers).forEach(function (name) {
                _this.append(name, headers[name]);
            });
        }
    }
    /**
     * Sets a new value for an existing header inside a `Headers` object, or adds the header if it does not already exist.
     */
    Headers.prototype.set = function (name, value) {
        this.map[this.normalizeName(name)] = this.normalizeValue(value);
    };
    /**
     * Appends a new value onto an existing header inside a `Headers` object, or adds the header if it does not already exist.
     */
    Headers.prototype.append = function (name, value) {
        name = this.normalizeName(name);
        value = this.normalizeValue(value);
        this.map[name] = this.has(name) ? this.map[name] + ", " + value : value;
    };
    /**
     * Deletes a header from the `Headers` object.
     */
    Headers.prototype.delete = function (name) {
        delete this.map[this.normalizeName(name)];
        return this;
    };
    /**
     * Returns a `ByteString` sequence of all the values of a header with a given name.
     */
    Headers.prototype.get = function (name) {
        return this.map[this.normalizeName(name)] || null;
    };
    /**
     * Returns the map of all headers in a `Headers` object.
     */
    Headers.prototype.getAllHeaders = function () {
        return this.map;
    };
    /**
     * Returns a boolean stating whether a `Headers` object contains a certain header.
     */
    Headers.prototype.has = function (name) {
        return this.map.hasOwnProperty(this.normalizeName(name));
    };
    Headers.prototype.forEach = function (callback, thisArg) {
        for (var name_1 in this.map) {
            if (this.map.hasOwnProperty(name_1)) {
                callback.call(thisArg, this.map[name_1], name_1, this);
            }
        }
    };
    Headers.prototype.normalizeName = function (name) {
        if (typeof name !== 'string') {
            name = String(name);
        }
        if (HEADERS_INVALID_CHARACTERS.test(name) || name.trim() === '') {
            throw new TypeError('Invalid character in header field name');
        }
        return name.toLowerCase();
    };
    Headers.prototype.normalizeValue = function (value) {
        if (typeof value !== 'string') {
            value = String(value);
        }
        return value;
    };
    return Headers;
}());
exports.Headers = Headers;
});

var headersToList_1 = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports, "__esModule", { value: true });
function headersToList(headers) {
    var headersList = [];
    headers.forEach(function (value, name) {
        var resolvedValue = value.includes(',')
            ? value.split(',').map(function (v) { return v.trim(); })
            : value;
        headersList.push([name, resolvedValue]);
    });
    return headersList;
}
exports.headersToList = headersToList;
});

var headersToObject_1 = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports, "__esModule", { value: true });
// List of headers that cannot have multiple values,
// while potentially having a comma in their single value.
var singleValueHeaders = ['user-agent'];
/**
 * Converts a given `Headers` instance into a plain object.
 * Respects headers with multiple values.
 */
function headersToObject(headers) {
    var headersObject = {};
    headers.forEach(function (value, name) {
        var isMultiValue = !singleValueHeaders.includes(name.toLowerCase()) && value.includes(',');
        headersObject[name] = isMultiValue
            ? value.split(',').map(function (s) { return s.trim(); })
            : value;
    });
    return headersObject;
}
exports.headersToObject = headersToObject;
});

var stringToHeaders_1 = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Converts a string representation of headers (i.e. from XMLHttpRequest)
 * to a new `Headers` instance.
 */
function stringToHeaders(str) {
    var lines = str.trim().split(/[\r\n]+/);
    return lines.reduce(function (headers, line) {
        var parts = line.split(': ');
        var name = parts.shift();
        var value = parts.join(': ');
        headers.append(name, value);
        return headers;
    }, new Headers());
}
exports.stringToHeaders = stringToHeaders;
});

var listToHeaders_1 = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports, "__esModule", { value: true });
function listToHeaders(list) {
    var headers = new Headers();
    list.forEach(function (_a) {
        var name = _a[0], value = _a[1];
        var values = [].concat(value);
        values.forEach(function (value) {
            headers.append(name, value);
        });
    });
    return headers;
}
exports.listToHeaders = listToHeaders;
});

var reduceHeadersObject_1 = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Reduces given headers object instnace.
 */
function reduceHeadersObject(headers, reducer, initialState) {
    return Object.keys(headers).reduce(function (nextHeaders, name) {
        return reducer(nextHeaders, name, headers[name]);
    }, initialState);
}
exports.reduceHeadersObject = reduceHeadersObject;
});

var objectToHeaders_1 = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports, "__esModule", { value: true });

/**
 * Converts a given headers object to a new `Headers` instance.
 */
function objectToHeaders(obj) {
    return reduceHeadersObject_1.reduceHeadersObject(obj, function (headers, name, value) {
        var values = [].concat(value);
        values.forEach(function (value) {
            headers.append(name, value);
        });
        return headers;
    }, new Headers());
}
exports.objectToHeaders = objectToHeaders;
});

var flattenHeadersList_1 = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports, "__esModule", { value: true });
function flattenHeadersList(list) {
    return list.map(function (_a) {
        var name = _a[0], values = _a[1];
        return [name, [].concat(values).join('; ')];
    });
}
exports.flattenHeadersList = flattenHeadersList;
});

var flattenHeadersObject_1 = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports, "__esModule", { value: true });

function flattenHeadersObject(obj) {
    return reduceHeadersObject_1.reduceHeadersObject(obj, function (headers, name, value) {
        headers[name] = [].concat(value).join('; ');
        return headers;
    }, {});
}
exports.flattenHeadersObject = flattenHeadersObject;
});

var lib = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports, "__esModule", { value: true });

exports.Headers = Headers_1.Headers;

exports.headersToList = headersToList_1.headersToList;

exports.headersToObject = headersToObject_1.headersToObject;

exports.stringToHeaders = stringToHeaders_1.stringToHeaders;

exports.listToHeaders = listToHeaders_1.listToHeaders;

exports.objectToHeaders = objectToHeaders_1.objectToHeaders;

exports.reduceHeadersObject = reduceHeadersObject_1.reduceHeadersObject;

exports.flattenHeadersList = flattenHeadersList_1.flattenHeadersList;

exports.flattenHeadersObject = flattenHeadersObject_1.flattenHeadersObject;
});

/**
 * Sets one or multiple response headers.
 * @see {@link https://mswjs.io/docs/api/context/set `ctx.set()`}
 */
function set(...args) {
    return (res) => {
        const [name, value] = args;
        if (typeof name === 'string') {
            res.headers.append(name, value);
        }
        else {
            const headers = lib.objectToHeaders(name);
            headers.forEach((value, name) => {
                res.headers.append(name, value);
            });
        }
        return res;
    };
}

/**
 * Parses a given string into a JSON.
 * Does not throw an exception on an invalid JSON string.
 */
function jsonParse(str) {
    try {
        return JSON.parse(str);
    }
    catch (error) {
        return undefined;
    }
}

/**
 * Sets the given value as the JSON body of the response.
 * Appends a `Content-Type: application/json` header on the
 * mocked response.
 * @example
 * res(ctx.json('Some string'))
 * res(ctx.json({ key: 'value' }))
 * res(ctx.json([1, '2', false, { ok: true }]))
 * @see {@link https://mswjs.io/docs/api/context/json `ctx.json()`}
 */
const json = (body) => {
    return (res) => {
        res.headers.set('Content-Type', 'application/json');
        res.body = JSON.stringify(body);
        return res;
    };
};

/**
 * Returns a boolean indicating if the current process is running in NodeJS environment.
 * @see https://github.com/mswjs/msw/pull/255
 */
function isNodeProcess() {
    // Check browser environment.
    if (typeof global !== 'object') {
        return false;
    }
    // Check nodejs or React Native environment.
    if (Object.prototype.toString.call(global.process) === '[object process]' ||
        navigator.product === 'ReactNative') {
        return true;
    }
}

const MIN_SERVER_RESPONSE_TIME = 100;
const MAX_SERVER_RESPONSE_TIME = 400;
const NODE_SERVER_RESPONSE_TIME = 5;
const getRandomServerResponseTime = () => {
    if (isNodeProcess()) {
        return NODE_SERVER_RESPONSE_TIME;
    }
    return Math.floor(Math.random() * (MAX_SERVER_RESPONSE_TIME - MIN_SERVER_RESPONSE_TIME) +
        MIN_SERVER_RESPONSE_TIME);
};
/**
 * Delays the response by the given duration (ms).
 * @example
 * res(ctx.delay()) // realistic server response time
 * res(ctx.delay(1200))
 * @see {@link https://mswjs.io/docs/api/context/delay `ctx.delay()`}
 */
const delay = (durationMs) => {
    return (res) => {
        res.delay = durationMs !== null && durationMs !== void 0 ? durationMs : getRandomServerResponseTime();
        return res;
    };
};

const useFetch = isNodeProcess() ? require('node-fetch') : window.fetch;
const augmentRequestInit = (requestInit) => {
    const headers = new lib.Headers(requestInit.headers);
    headers.set('x-msw-bypass', 'true');
    return Object.assign(Object.assign({}, requestInit), { headers: headers.getAllHeaders() });
};
const createFetchRequestParameters = (input) => {
    const { body, method } = input;
    const requestParameters = Object.assign(Object.assign({}, input), { body: undefined });
    if (['GET', 'HEAD'].includes(method)) {
        return requestParameters;
    }
    requestParameters.body =
        typeof body === 'object' ? JSON.stringify(body) : body;
    return requestParameters;
};
/**
 * Performs a bypassed request inside a request handler.
 * @example
 * const originalResponse = await ctx.fetch(req)
 * @see {@link https://mswjs.io/docs/api/context/fetch `ctx.fetch()`}
 */
const fetch = (input, requestInit = {}) => {
    // Keep the default `window.fetch()` call signature
    if (typeof input === 'string') {
        return useFetch(input, augmentRequestInit(requestInit));
    }
    const requestParameters = createFetchRequestParameters(input);
    const compliantRequest = augmentRequestInit(requestParameters);
    return useFetch(input.url.href, compliantRequest);
};

export { set as a, commonjsGlobal as b, createCommonjsModule as c, delay as d, jsonParse as e, fetch as f, isNodeProcess as i, json as j, lib as l, status as s };
