import { OperationTypeNode } from 'graphql';
import { RequestHandler, MockedRequest, AsyncResponseResolverReturnType } from './utils/handlers/requestHandler';
import { MockedResponse, ResponseComposition } from './response';
import { Mask } from './setupWorker/glossary';
import { set } from './context/set';
import { status } from './context/status';
import { delay } from './context/delay';
import { fetch } from './context/fetch';
import { data } from './context/data';
import { errors } from './context/errors';
declare type GraphQLRequestHandlerSelector = RegExp | string;
export declare type GraphQLMockedRequest<VariablesType = Record<string, any>> = Omit<MockedRequest, 'body'> & {
    body: (GraphQLRequestPayload<VariablesType> & Record<string, any>) | undefined;
    variables: VariablesType;
};
export interface GraphQLMockedContext {
    set: typeof set;
    status: typeof status;
    delay: typeof delay;
    fetch: typeof fetch;
    data: typeof data;
    errors: typeof errors;
}
export declare const graphqlContext: GraphQLMockedContext;
export declare type GraphQLResponseResolver<QueryType, VariablesType> = (req: GraphQLMockedRequest<VariablesType>, res: ResponseComposition<any>, context: GraphQLMockedContext) => AsyncResponseResolverReturnType<MockedResponse>;
export interface GraphQLRequestPayload<VariablesType> {
    query: string;
    variables?: VariablesType;
}
export interface GraphQLRequestParsedResult<VariablesType> {
    operationType: OperationTypeNode;
    operationName: string | undefined;
    variables: VariablesType | undefined;
}
declare const graphqlStandardHandlers: {
    /**
     * Captures any GraphQL operation, regardless of its name, under the current scope.
     * @example
     * graphql.operation((req, res, ctx) => {
     *   return res(ctx.data({ name: 'John' }))
     * })
     * @see {@link https://mswjs.io/docs/api/graphql/operation `graphql.operation()`}
     */
    operation: <QueryType, VariablesType = Record<string, any>>(resolver: GraphQLResponseResolver<QueryType, VariablesType>) => RequestHandler<GraphQLMockedRequest<VariablesType>, GraphQLMockedContext, GraphQLRequestParsedResult<VariablesType>, GraphQLMockedRequest<VariablesType>, any>;
    /**
     * Captures a GraphQL query by a given name.
     * @example
     * graphql.query('GetUser', (req, res, ctx) => {
     *   return res(ctx.data({ user: { name: 'John' } }))
     * })
     * @see {@link https://mswjs.io/docs/api/graphql/query `graphql.query()`}
     */
    query: <QueryType_1, VariablesType_1 = Record<string, any>>(expectedOperationName: GraphQLRequestHandlerSelector, resolver: GraphQLResponseResolver<QueryType_1, VariablesType_1>) => RequestHandler<GraphQLMockedRequest<VariablesType_1>, GraphQLMockedContext, GraphQLRequestParsedResult<VariablesType_1>, GraphQLMockedRequest<VariablesType_1>, any>;
    /**
     * Captures a GraphQL mutation by a given name.
     * @example
     * graphql.mutation('SavePost', (req, res, ctx) => {
     *   return res(ctx.data({ post: { id: 'abc-123' } }))
     * })
     * @see {@link https://mswjs.io/docs/api/graphql/mutation `graphql.mutation()`}
     */
    mutation: <QueryType_1, VariablesType_1 = Record<string, any>>(expectedOperationName: GraphQLRequestHandlerSelector, resolver: GraphQLResponseResolver<QueryType_1, VariablesType_1>) => RequestHandler<GraphQLMockedRequest<VariablesType_1>, GraphQLMockedContext, GraphQLRequestParsedResult<VariablesType_1>, GraphQLMockedRequest<VariablesType_1>, any>;
};
/**
 * Creates a GraphQL mocking API scoped to the given endpoint.
 * @param uri Endpoint URL, or path.
 * @example
 * const api = graphql.link('https://api.site.com/graphql)
 * api.query('GetUser', resolver)
 * @see {@link https://mswjs.io/docs/api/graphql/link `graphql.link()`}
 */
declare function createGraphQLLink(uri: Mask): typeof graphqlStandardHandlers;
export declare const graphql: {
    link: typeof createGraphQLLink;
    /**
     * Captures any GraphQL operation, regardless of its name, under the current scope.
     * @example
     * graphql.operation((req, res, ctx) => {
     *   return res(ctx.data({ name: 'John' }))
     * })
     * @see {@link https://mswjs.io/docs/api/graphql/operation `graphql.operation()`}
     */
    operation: <QueryType, VariablesType = Record<string, any>>(resolver: GraphQLResponseResolver<QueryType, VariablesType>) => RequestHandler<GraphQLMockedRequest<VariablesType>, GraphQLMockedContext, GraphQLRequestParsedResult<VariablesType>, GraphQLMockedRequest<VariablesType>, any>;
    /**
     * Captures a GraphQL query by a given name.
     * @example
     * graphql.query('GetUser', (req, res, ctx) => {
     *   return res(ctx.data({ user: { name: 'John' } }))
     * })
     * @see {@link https://mswjs.io/docs/api/graphql/query `graphql.query()`}
     */
    query: <QueryType_1, VariablesType_1 = Record<string, any>>(expectedOperationName: GraphQLRequestHandlerSelector, resolver: GraphQLResponseResolver<QueryType_1, VariablesType_1>) => RequestHandler<GraphQLMockedRequest<VariablesType_1>, GraphQLMockedContext, GraphQLRequestParsedResult<VariablesType_1>, GraphQLMockedRequest<VariablesType_1>, any>;
    /**
     * Captures a GraphQL mutation by a given name.
     * @example
     * graphql.mutation('SavePost', (req, res, ctx) => {
     *   return res(ctx.data({ post: { id: 'abc-123' } }))
     * })
     * @see {@link https://mswjs.io/docs/api/graphql/mutation `graphql.mutation()`}
     */
    mutation: <QueryType_1, VariablesType_1 = Record<string, any>>(expectedOperationName: GraphQLRequestHandlerSelector, resolver: GraphQLResponseResolver<QueryType_1, VariablesType_1>) => RequestHandler<GraphQLMockedRequest<VariablesType_1>, GraphQLMockedContext, GraphQLRequestParsedResult<VariablesType_1>, GraphQLMockedRequest<VariablesType_1>, any>;
};
export {};
