import { RequestHandler, ResponseResolver, MockedRequest, DefaultRequestBodyType, RequestParams } from './utils/handlers/requestHandler';
import { Mask } from './setupWorker/glossary';
import { set } from './context/set';
import { status } from './context/status';
import { cookie } from './context/cookie';
import { body } from './context/body';
import { text } from './context/text';
import { json } from './context/json';
import { xml } from './context/xml';
import { delay } from './context/delay';
import { fetch } from './context/fetch';
import { matchRequestUrl } from './utils/matching/matchRequestUrl';
export declare enum RESTMethods {
    HEAD = "HEAD",
    GET = "GET",
    POST = "POST",
    PUT = "PUT",
    PATCH = "PATCH",
    OPTIONS = "OPTIONS",
    DELETE = "DELETE"
}
export interface RestContext {
    set: typeof set;
    status: typeof status;
    cookie: typeof cookie;
    text: typeof text;
    body: typeof body;
    json: typeof json;
    xml: typeof xml;
    delay: typeof delay;
    fetch: typeof fetch;
}
export declare const restContext: RestContext;
export interface ParsedRestRequest {
    match: ReturnType<typeof matchRequestUrl>;
}
export declare const rest: {
    /**
     * Captures a HEAD request by a given path.
     * @example
     * rest.head('/numbers', (req, res, ctx) => {
     *   return res(ctx.status(302))
     * })
     * @see {@link https://mswjs.io/docs/api/rest `rest`}
     */
    head: <RequestBodyType = DefaultRequestBodyType, ResponseBodyType = any, RequestParamsType extends RequestParams = RequestParams>(mask: Mask, resolver: ResponseResolver<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ResponseBodyType>) => RequestHandler<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ParsedRestRequest, MockedRequest<RequestBodyType, RequestParams>, ResponseBodyType>;
    /**
     * Captures a GET request by a given path.
     * @example
     * rest.get('/numbers', (req, res, ctx) => {
     *   return res(ctx.json([1, 2, 3]))
     * })
     * @see {@link https://mswjs.io/docs/api/rest `rest`}
     */
    get: <RequestBodyType = DefaultRequestBodyType, ResponseBodyType = any, RequestParamsType extends RequestParams = RequestParams>(mask: Mask, resolver: ResponseResolver<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ResponseBodyType>) => RequestHandler<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ParsedRestRequest, MockedRequest<RequestBodyType, RequestParams>, ResponseBodyType>;
    /**
     * Captures a POST request by a given path.
     * @example
     * rest.post('/numbers', (req, res, ctx) => {
     *   return res(ctx.text('success'))
     * })
     * @see {@link https://mswjs.io/docs/api/rest `rest`}
     */
    post: <RequestBodyType = DefaultRequestBodyType, ResponseBodyType = any, RequestParamsType extends RequestParams = RequestParams>(mask: Mask, resolver: ResponseResolver<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ResponseBodyType>) => RequestHandler<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ParsedRestRequest, MockedRequest<RequestBodyType, RequestParams>, ResponseBodyType>;
    /**
     * Captures a PUT request by a given path.
     * @example
     * rest.put('/numbers', (req, res, ctx) => {
     *   const { numbers } = req.body
     *   return res(ctx.json(numbers))
     * })
     * @see {@link https://mswjs.io/docs/api/rest `rest`}
     */
    put: <RequestBodyType = DefaultRequestBodyType, ResponseBodyType = any, RequestParamsType extends RequestParams = RequestParams>(mask: Mask, resolver: ResponseResolver<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ResponseBodyType>) => RequestHandler<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ParsedRestRequest, MockedRequest<RequestBodyType, RequestParams>, ResponseBodyType>;
    /**
     * Captures a DELETE request by a given path.
     * @example
     * rest.delete('/numbers', (req, res, ctx) => {
     *   const index = req.url.searchParams.get('index')
     *   prevNumbers.splice(index, 1)
     *   return res(ctx.json(nextNumbers))
     * })
     * @see {@link https://mswjs.io/docs/api/rest `rest`}
     */
    delete: <RequestBodyType = DefaultRequestBodyType, ResponseBodyType = any, RequestParamsType extends RequestParams = RequestParams>(mask: Mask, resolver: ResponseResolver<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ResponseBodyType>) => RequestHandler<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ParsedRestRequest, MockedRequest<RequestBodyType, RequestParams>, ResponseBodyType>;
    /**
     * Captures a PATCH request by a given path.
     * @example
     * rest.patch('/numbers', (req, res, ctx) => {
     *   const { numbers } = req.body
     *   const nextNumbers = prevNumbers.concat(number)
     *   return res(ctx.json(nextNumbers))
     * })
     * @see {@link https://mswjs.io/docs/api/rest `rest`}
     */
    patch: <RequestBodyType = DefaultRequestBodyType, ResponseBodyType = any, RequestParamsType extends RequestParams = RequestParams>(mask: Mask, resolver: ResponseResolver<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ResponseBodyType>) => RequestHandler<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ParsedRestRequest, MockedRequest<RequestBodyType, RequestParams>, ResponseBodyType>;
    /**
     * Captures an OPTIONS request by a given path.
     * @example
     * rest.options('/numbers', (req, res, ctx) => {
     *   return res(ctx.set('Allow', 'GET,HEAD,POST'))
     * })
     * @see {@link https://mswjs.io/docs/api/rest `rest`}
     */
    options: <RequestBodyType = DefaultRequestBodyType, ResponseBodyType = any, RequestParamsType extends RequestParams = RequestParams>(mask: Mask, resolver: ResponseResolver<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ResponseBodyType>) => RequestHandler<MockedRequest<RequestBodyType, RequestParamsType>, RestContext, ParsedRestRequest, MockedRequest<RequestBodyType, RequestParams>, ResponseBodyType>;
};
