import { Headers } from 'headers-utils';
import { Mask, ResponseWithSerializedHeaders } from '../../setupWorker/glossary';
import { ResponseComposition, MockedResponse } from '../../response';
import { set } from '../../context/set';
export declare const defaultContext: {
    status: (statusCode: number, statusText?: string | undefined) => import("../../response").ResponseTransformer<any>;
    set: typeof set;
    delay: (durationMs?: number | undefined) => import("../../response").ResponseTransformer<any>;
    fetch: (input: string | MockedRequest<DefaultRequestBodyType, RequestParams>, requestInit?: RequestInit) => any;
};
export declare type DefaultRequestBodyType = Record<string, any> | string | undefined;
export interface MockedRequest<BodyType = DefaultRequestBodyType, RequestParamsType = RequestParams> {
    url: URL;
    method: Request['method'];
    headers: Headers;
    cookies: Record<string, string>;
    mode: Request['mode'];
    keepalive: Request['keepalive'];
    cache: Request['cache'];
    destination: Request['destination'];
    integrity: Request['integrity'];
    credentials: Request['credentials'];
    redirect: Request['redirect'];
    referrer: Request['referrer'];
    referrerPolicy: Request['referrerPolicy'];
    body: BodyType;
    bodyUsed: Request['bodyUsed'];
    params: RequestParamsType;
}
export declare type RequestQuery = {
    [queryName: string]: any;
};
export declare type RequestParams = {
    [paramName: string]: any;
};
export declare type ResponseResolverReturnType<R> = R | undefined | void;
export declare type AsyncResponseResolverReturnType<R> = Promise<ResponseResolverReturnType<R>> | ResponseResolverReturnType<R>;
export declare type ResponseResolver<RequestType = MockedRequest, ContextType = typeof defaultContext, BodyType = any> = (req: RequestType, res: ResponseComposition<BodyType>, context: ContextType) => AsyncResponseResolverReturnType<MockedResponse<BodyType>>;
declare type RequestHandlerType = 'rest' | 'graphql';
export interface RequestHandlerMetaInfo<Type = RequestHandlerType> {
    type: Type;
    header: string;
    mask: Mask;
    callFrame: string | undefined;
}
export interface RequestHandler<RequestType = MockedRequest, ContextType = typeof defaultContext, ParsedRequest = any, PublicRequest = RequestType, ResponseBodyType = any> {
    /**
     * Parses a captured request to retrieve additional
     * information meant for internal usage in the request handler.
     */
    parse?: (req: RequestType) => ParsedRequest | null;
    /**
     * Returns a modified request with necessary public properties appended.
     */
    getPublicRequest?: (req: RequestType, parsedRequest: ParsedRequest) => PublicRequest;
    /**
     * Predicate function that decides whether a Request should be mocked.
     */
    predicate: (req: RequestType, parsedRequest: ParsedRequest) => boolean;
    /**
     * Returns a mocked response object to the captured request.
     */
    resolver: ResponseResolver<RequestType, ContextType, ResponseBodyType>;
    /**
     * Returns a map of context utility functions available
     * under the `ctx` argument of request handler.
     */
    defineContext?: (req: PublicRequest) => ContextType;
    /**
     * Prints out a mocked request/response information
     * upon each request capture into browser's console.
     */
    log: (req: PublicRequest, res: ResponseWithSerializedHeaders, handler: RequestHandler<RequestType, ContextType, ParsedRequest, PublicRequest, ResponseBodyType>, parsedRequest: ParsedRequest) => void;
    /**
     * Describes whether this request handler should be skipped
     * when dealing with any subsequent matching requests.
     */
    shouldSkip?: boolean;
    /**
     * Returns request handler's meta information used
     * when listing each current request handler.
     */
    getMetaInfo: () => RequestHandlerMetaInfo;
}
declare const _default: null;
export default _default;
