declare type ArityOneFn = (arg: any) => any;
declare type PickLastInTuple<T extends any[]> = T extends [
    ...rest: infer U,
    argn: infer L
] ? L : never;
declare type FirstFnParameterType<T extends any[]> = Parameters<PickLastInTuple<T>>[any];
declare type LastFnParameterType<T extends any[]> = ReturnType<T[0]>;
/**
 * Composes a given list of functions into a new function that
 * executes from right to left.
 */
export declare function compose<T extends ArityOneFn[], LeftReturnType extends FirstFnParameterType<T>, RightReturnType extends LastFnParameterType<T>>(...fns: T): (...args: LeftReturnType extends never ? never[] : [LeftReturnType]) => RightReturnType;
export {};
