/// <reference types="node" />
/// <reference lib="es2016" />
/// <reference lib="es2017.sharedmemory" />
/// <reference lib="esnext.asynciterable" />
/// <reference lib="dom" />
declare type TypedArray = Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array | Float64Array;
declare type Primitive = null | undefined | string | number | boolean | Symbol;
export interface ArrayLike {
    length: number;
}
export interface Class<T = any> {
    new (...args: any[]): T;
}
declare type DomElement = object & {
    nodeType: 1;
    nodeName: string;
};
declare type NodeStream = object & {
    pipe: Function;
};
export declare const enum TypeName {
    null = "null",
    boolean = "boolean",
    undefined = "undefined",
    string = "string",
    number = "number",
    symbol = "symbol",
    Function = "Function",
    GeneratorFunction = "GeneratorFunction",
    AsyncFunction = "AsyncFunction",
    Observable = "Observable",
    Array = "Array",
    Buffer = "Buffer",
    Object = "Object",
    RegExp = "RegExp",
    Date = "Date",
    Error = "Error",
    Map = "Map",
    Set = "Set",
    WeakMap = "WeakMap",
    WeakSet = "WeakSet",
    Int8Array = "Int8Array",
    Uint8Array = "Uint8Array",
    Uint8ClampedArray = "Uint8ClampedArray",
    Int16Array = "Int16Array",
    Uint16Array = "Uint16Array",
    Int32Array = "Int32Array",
    Uint32Array = "Uint32Array",
    Float32Array = "Float32Array",
    Float64Array = "Float64Array",
    ArrayBuffer = "ArrayBuffer",
    SharedArrayBuffer = "SharedArrayBuffer",
    DataView = "DataView",
    Promise = "Promise",
    URL = "URL"
}
declare function is(value: any): TypeName;
declare namespace is {
    const undefined: (value: any) => value is undefined;
    const string: (value: any) => value is string;
    const number: (value: any) => value is number;
    const function_: (value: any) => value is Function;
    const null_: (value: any) => value is null;
    const class_: (value: any) => value is Class<any>;
    const boolean: (value: any) => value is boolean;
    const symbol: (value: any) => value is Symbol;
    const array: (arg: any) => arg is any[];
    const buffer: (input: any) => input is Buffer;
    const nullOrUndefined: (value: any) => value is null | undefined;
    const object: (value: any) => value is object;
    const iterable: (value: any) => value is IterableIterator<any>;
    const asyncIterable: (value: any) => value is AsyncIterableIterator<any>;
    const generator: (value: any) => value is Generator;
    const nativePromise: (value: any) => value is Promise<any>;
    const promise: (value: any) => value is Promise<any>;
    const generatorFunction: (value: any) => value is GeneratorFunction;
    const asyncFunction: (value: any) => value is Function;
    const boundFunction: (value: any) => value is Function;
    const regExp: (value: any) => value is RegExp;
    const date: (value: any) => value is Date;
    const error: (value: any) => value is Error;
    const map: (value: any) => value is Map<any, any>;
    const set: (value: any) => value is Set<any>;
    const weakMap: (value: any) => value is WeakMap<any, any>;
    const weakSet: (value: any) => value is WeakSet<any>;
    const int8Array: (value: any) => value is Int8Array;
    const uint8Array: (value: any) => value is Uint8Array;
    const uint8ClampedArray: (value: any) => value is Uint8ClampedArray;
    const int16Array: (value: any) => value is Int16Array;
    const uint16Array: (value: any) => value is Uint16Array;
    const int32Array: (value: any) => value is Int32Array;
    const uint32Array: (value: any) => value is Uint32Array;
    const float32Array: (value: any) => value is Float32Array;
    const float64Array: (value: any) => value is Float64Array;
    const arrayBuffer: (value: any) => value is ArrayBuffer;
    const sharedArrayBuffer: (value: any) => value is SharedArrayBuffer;
    const dataView: (value: any) => value is DataView;
    const directInstanceOf: <T>(instance: any, klass: Class<T>) => instance is T;
    const urlInstance: (value: any) => value is URL;
    const truthy: (value: any) => boolean;
    const falsy: (value: any) => boolean;
    const nan: (value: any) => boolean;
    const primitive: (value: any) => value is Primitive;
    const integer: (value: any) => value is number;
    const safeInteger: (value: any) => value is number;
    const plainObject: (value: any) => boolean;
    const typedArray: (value: any) => value is TypedArray;
    const arrayLike: (value: any) => value is ArrayLike;
    const inRange: (value: number, range: number | number[]) => boolean;
    const domElement: (value: any) => value is DomElement;
    const observable: (value: any) => boolean;
    const nodeStream: (value: any) => value is NodeStream;
    const infinite: (value: any) => boolean;
    const even: (value: number) => boolean;
    const odd: (value: number) => boolean;
    const emptyArray: (value: any) => boolean;
    const nonEmptyArray: (value: any) => boolean;
    const emptyString: (value: any) => boolean;
    const nonEmptyString: (value: any) => boolean;
    const emptyStringOrWhitespace: (value: any) => boolean;
    const emptyObject: (value: any) => boolean;
    const nonEmptyObject: (value: any) => boolean;
    const emptySet: (value: any) => boolean;
    const nonEmptySet: (value: any) => boolean;
    const emptyMap: (value: any) => boolean;
    const nonEmptyMap: (value: any) => boolean;
    const any: (predicate: any, ...values: any[]) => any;
    const all: (predicate: any, ...values: any[]) => any;
}
export default is;
