import os
import sys
from alembic.config import CommandLine, Config
from library.python import resource

from crm.agency_cabinet.agencies.server.src.config import db_config

MIGRATIONS_REL_PATH = 'crm/agency_cabinet/agencies/server/migrations/'  # такой же, как PREFIX в ya.make
MIGRATIONS_ABS_PATH = '.'  # '{ARCADIA_ROOT} + MIGRATIONS_REL_PATH сюда будет распакованы миграции, если нужных файлов нет


def extract_resources():
    for res, data in resource.iteritems(prefix='resfs/file/{}'.format(MIGRATIONS_REL_PATH), strip_prefix=True):
        path = os.path.join(MIGRATIONS_ABS_PATH, res)

        if not os.path.exists(path):
            parent = os.path.normpath(os.path.join(path, os.pardir))
            if not os.path.exists(parent):
                os.makedirs(parent)
            with open(path, 'wb') as f:
                f.write(data)


# TODO вынести main в common, передавать MIGRATIONS_ABS_PATH и MIGRATIONS_REL_PATH в аргументах
def main():
    extract_resources()

    cl = CommandLine()
    options = cl.parser.parse_args(sys.argv[1:])

    cfg = Config(
        file_='{}/alembic.ini'.format(MIGRATIONS_ABS_PATH),
        ini_section=options.name,
        cmd_opts=options,
    )

    cfg.set_main_option('script_location', MIGRATIONS_ABS_PATH)
    cfg.set_main_option('version_locations', '{}/versions'.format(MIGRATIONS_ABS_PATH))

    url = "postgresql+psycopg2://{user}:{password}@/{dbname}?host={host}&port={port}&" \
          "target_session_attrs=read-write".format(user=db_config.db['dsn'].username,
                                                    password=db_config.db['dsn'].password,
                                                    dbname=db_config.db['dsn'].database,
                                                    host=db_config.db['dsn'].host,
                                                    port=db_config.db['dsn'].port)

    cfg.set_main_option('sqlalchemy.url', url)
    cfg.set_main_option('file_template', '%%(year)d%%(month).2d%%(day).2d%%(hour).2d%%(minute).2d%%(second).2d_%%(rev)s_%%(slug)s')

    sys.exit(cl.run_cmd(cfg, options))


if __name__ == '__main__':
    main()
