"""init

Revision ID: cc529c7b57b0
Revises:
Create Date: 2021-07-05 13:51:33.676490+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = 'cc529c7b57b0'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute('CREATE SCHEMA agencies')

    op.create_table('agency',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('name', sa.Text(), nullable=False),
                    sa.Column('phone', sa.Text()),
                    sa.Column('email', sa.Text()),
                    sa.Column('site', sa.Text()),
                    sa.Column('actual_address', sa.Text()),
                    sa.Column('legal_address', sa.Text()),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('agency__pk')),
                    schema='agencies'
                    )
    op.create_table('contract',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('eid', sa.Text(), nullable=False),
                    sa.Column('agency_id', sa.BigInteger(), nullable=False),
                    sa.Column('payment_type', sa.Text(), nullable=False),
                    sa.Column('till_dt', sa.DateTime(timezone=True), nullable=False),
                    sa.Column('inn', sa.Text(), nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.ForeignKeyConstraint(['agency_id'], ['agencies.agency.id'], name='contract__agency_id__fk'),
                    sa.PrimaryKeyConstraint('id', name=op.f('contract__pk')),
                    sa.UniqueConstraint('eid', name=op.f('contract__eid__uq')),
                    schema='agencies'
                    )
    op.create_index('contract__agency_id__idx', 'contract', ['agency_id'], unique=False, schema='agencies')

    op.create_table('tools_yt_sync',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('path', sa.Text(), nullable=True),
                    sa.Column('last_used_update', sa.DateTime(timezone=True), nullable=True),
                    sa.Column('enabled', sa.Boolean(), server_default='t', nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('tools_yt_sync__pk')),
                    sa.UniqueConstraint('path', name=op.f('tools_yt_sync__path__uq')),
                    schema='agencies'
                    )
    op.create_index('tools_yt_sync__path__idx', 'tools_yt_sync', ['path'], unique=False, schema='agencies')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('tools_yt_sync__path__idx', table_name='tools_yt_sync', schema='agencies')
    op.drop_table('tools_yt_sync', schema='agencies')
    op.drop_index('contract__agency_id__idx', table_name='contract', schema='agencies')
    op.drop_table('contract', schema='agencies')
    op.drop_table('agency', schema='agencies')

    op.execute('DROP SCHEMA agencies')
    # ### end Alembic commands ###
