"""clients

Revision ID: ece44e8553d5
Revises: cc529c7b57b0
Create Date: 2021-08-25 11:13:07.214051+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = 'ece44e8553d5'
down_revision = 'cc529c7b57b0'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('client',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('name', sa.Text(), nullable=False),
    sa.Column('agency_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.ForeignKeyConstraint(['agency_id'], ['agencies.agency.id'], name=op.f('client_agency__agency_id__fk')),
    sa.PrimaryKeyConstraint('id', name=op.f('client__pk')),
    schema='agencies'
    )
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('client', schema='agencies')
    # ### end Alembic commands ###
