"""Add login and made name nullable

Revision ID: 83b3bf2359fd
Revises: ece44e8553d5
Create Date: 2021-09-09 14:49:26.221418+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv

# revision identifiers, used by Alembic.
revision = '83b3bf2359fd'
down_revision = 'ece44e8553d5'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('client', sa.Column('login', sa.Text(), nullable=False), schema='agencies')
    op.alter_column(
        'client', 'name',
        existing_type=sa.TEXT(),
        nullable=True,
        schema='agencies',
    )
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        'client', 'name',
        existing_type=sa.TEXT(),
        nullable=False,
        schema='agencies',
    )
    op.drop_column('client', 'login', schema='agencies')
    # ### end Alembic commands ###
