"""analytics

Revision ID: 7bd4023878c4
Revises: b071ab680aaf
Create Date: 2021-11-08 20:04:19.665002+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = '7bd4023878c4'
down_revision = 'b071ab680aaf'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('agency_analytics',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('agency_id', sa.BigInteger(), nullable=False),
    sa.Column('client_id', sa.BigInteger(), nullable=False),
    sa.Column('all_money', sa.Numeric(precision=18, scale=6), nullable=True),
    sa.Column('check_ctg', sa.Integer(), nullable=False),
    sa.Column('cohort_date', sa.Date(), nullable=False),
    sa.Column('month', sa.Date(), nullable=False),
    sa.Column('domain', sa.Text(), nullable=True),
    sa.Column('epoch', sa.Integer(), nullable=False),
    sa.Column('role', sa.Text(), nullable=False),
    sa.Column('tier', sa.Text(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.ForeignKeyConstraint(['agency_id'], ['agencies.agency.id'], name='agency_analytics__agency_id__fk'),
    # sa.ForeignKeyConstraint(['client_id'], ['agencies.client.id'], name='agency_analytics__client_id__fk'),
    sa.PrimaryKeyConstraint('id', name=op.f('agency_analytics__pk')),
    schema='agencies'
    )
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('agency_analytics', schema='agencies')
    # ### end Alembic commands ###
