"""empty message

Revision ID: 6b0c61d0e250
Revises: 7bd4023878c4
Create Date: 2022-03-29 23:37:07.038086+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv
import platform



# revision identifiers, used by Alembic.
revision = '6b0c61d0e250'
down_revision = '7bd4023878c4'
branch_labels = None
depends_on = None


def upgrade():
    if yenv.type != 'development' or platform.system() != 'Darwin':
        collation = 'C.UTF-8'
    else:
        collation = 'ru_RU.UTF-8'

    op.alter_column('client', 'name', type_=sa.Text(collation=collation), schema='agencies')
    op.alter_column('client', 'login', type_=sa.Text(collation=collation), schema='agencies')


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    op.alter_column('client', 'name', type_=sa.Text(), schema='agencies')
    op.alter_column('client', 'login', type_=sa.Text(), schema='agencies')
