import asyncio
import logging.config

from crm.agency_cabinet.agencies.common import QUEUE
from crm.agency_cabinet.agencies.server.src.config import db_config
from crm.agency_cabinet.agencies.server.src.db.engine import db
from crm.agency_cabinet.agencies.server.src.handler import Handler
from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.common.server.common.logging_config import get_logging_config
from crm.agency_cabinet.common.server.rpc.config import RpcServerConfig
from crm.agency_cabinet.common.monitoring.utils.server import run_ping_service
from crm.agency_cabinet.common.monitoring.utils.registry import setup_monitoring


__all__ = ['run_server']


def run_server():
    cfg = RpcServerConfig.from_environ()
    logging.config.dictConfig(get_logging_config(cfg.verbose))

    asyncio.run(_run_server(cfg))


async def _run_server(cfg: RpcServerConfig):
    await db.set_bind(bind=db_config.db['dsn'], ssl=db_config.db['ssl'], pool_class=db_config.db['pool_class'])
    metric_registry = setup_monitoring()
    async with ServiceDiscovery(cfg.amqp_url, with_rpc_client=False) as sd:  # type: ServiceDiscovery
        handler = Handler()

        async with sd.rpc_server(QUEUE) as server:
            await asyncio.gather(server.drain(handler), run_ping_service(metric_registry))
