from crm.agency_cabinet.common.celery.base import ContextTask, CeleryAppFactoryContextTask
from crm.agency_cabinet.agencies.server.src import config
from crm.agency_cabinet.agencies.server.src.db.engine import db


class AgenciesContextTask(ContextTask):
    pass


celery_app = CeleryAppFactoryContextTask(
    'agencies_tasks',
    scheduler_lock_settings=config.SCHEDULER_LOCK_SETTINGS,
    celery_settings=config.CELERY_SETTINGS,
    db_config=config.db_config.db,
    db=db,
    task_class=AgenciesContextTask).create()
