from crm.agency_cabinet.common.celery.load_client_info import load_client_info

from crm.agency_cabinet.agencies.server.src import config
from crm.agency_cabinet.agencies.server.src.celery.base import celery_app as celery
from crm.agency_cabinet.agencies.server.src.db import models


@celery.task(bind=True)
def load_client_info_task(self, force_load: bool = False):
    load_client_info(
        model=models.Client,
        yt_token=config.YT_CONFIG['TOKEN'],
        yql_token=config.YQL_CONFIG['TOKEN'],
        force_load=force_load
    )
