from crm.agency_cabinet.common.db.models import BaseModel, db


class AgencyAnalytics(BaseModel):
    __tablename__ = 'agency_analytics'

    id = db.Column(db.BigInteger, primary_key=True)
    agency_id = db.Column(db.BigInteger, nullable=False)
    client_id = db.Column(db.BigInteger, nullable=False)
    all_money = db.Column(db.Numeric(precision=18, scale=6), nullable=True, default=0)
    check_ctg = db.Column(db.Integer, nullable=False)
    cohort_date = db.Column(db.Date, nullable=False)
    month = db.Column(db.Date, nullable=False)
    domain = db.Column(db.Text, nullable=True)
    epoch = db.Column(db.Integer, nullable=False)
    role = db.Column(db.Text, nullable=False)
    tier = db.Column(db.Text, nullable=False)

    __table_args__ = (
        db.ForeignKeyConstraint(
            ['agency_id'],
            ['agency.id'],
            name='agency_analytics__agency_id__fk'
        ),
        # db.ForeignKeyConstraint(
        #    ['client_id'],
        #    ['client.id'],
        #    name='agency_analytics__client_id__fk'
        # )
    )
