from crm.agency_cabinet.common.db.models import BaseModel, db


class Client(BaseModel):
    __tablename__ = 'client'

    id = db.Column(db.BigInteger, primary_key=True)
    name = db.Column(db.Text, nullable=True)
    agency_id = db.Column(db.BigInteger, nullable=False)
    login = db.Column(db.Text, nullable=False)

    __table_args__ = (
        db.ForeignKeyConstraint(['agency_id'], ['agency.id']),
    )
