from crm.agency_cabinet.common.db.models import BaseModel, db


class Contract(BaseModel):
    __tablename__ = 'contract'

    id = db.Column(db.BigInteger, primary_key=True)
    eid = db.Column(db.Text, nullable=False, unique=True)
    agency_id = db.Column(db.BigInteger, nullable=False)
    payment_type = db.Column(db.Text, nullable=False)
    till_dt = db.Column(db.DateTime(timezone=True), nullable=False)
    inn = db.Column(db.Text, nullable=False)

    __table_args__ = (
        db.Index(
            'contract__agency_id__idx',
            'agency_id',
            unique=False
        ),
        db.ForeignKeyConstraint(
            ['agency_id'],
            ['agency.id'],
            name='contract__agency_id__fk'
        )
    )
