from library.python.monlib.metric_registry import MetricRegistry
from smb.common.rmq.rpc.server import BaseRpcHandler
from crm.agency_cabinet.agencies.proto import common_pb2, request_pb2, agency_info_pb2, clients_pb2, analytics_pb2
from crm.agency_cabinet.agencies.common import structs
from crm.agency_cabinet.agencies.server.src import procedures


class Handler(BaseRpcHandler):
    _request_proto = request_pb2.RpcRequest

    def __init__(self, metric_registry: MetricRegistry = None):
        self.metric_registry = metric_registry

    async def ping(self, _: common_pb2.Empty) -> common_pb2.PingOutput:
        return common_pb2.PingOutput(ping='pong')

    async def get_agencies_info(self, message: agency_info_pb2.GetAgenciesInfo) -> agency_info_pb2.GetAgenciesInfoOutput:
        result = await procedures.GetAgenciesInfo()(request=structs.GetAgenciesInfoRequest.from_proto(message))
        return agency_info_pb2.GetAgenciesInfoOutput(result=result.to_proto())

    async def get_all_agencies_info(self, _: common_pb2.Empty) -> agency_info_pb2.GetAgenciesInfoOutput:
        result = await procedures.GetAllAgenciesInfo()()
        return agency_info_pb2.GetAgenciesInfoOutput(result=result.to_proto())

    async def get_client_info(self, message: clients_pb2.GetClientInfo) -> clients_pb2.GetClientInfoOutput:
        try:
            result = await procedures.GetClientInfo()(request=structs.GetClientInfoRequest.from_proto(message))
            return clients_pb2.GetClientInfoOutput(result=result.to_proto())
        except procedures.NoSuchClient:
            return clients_pb2.GetClientInfoOutput(no_such_client=common_pb2.Empty())
        except procedures.UnsuitableAgency:
            return clients_pb2.GetClientInfoOutput(unsuitable_agency=common_pb2.Empty())

    async def get_clients_info(self, message: clients_pb2.GetClientsInfo) -> clients_pb2.GetClientsInfoOutput:
        result = await procedures.GetClientsInfo()(request=structs.GetClientsInfoRequest.from_proto(message))
        return clients_pb2.GetClientsInfoOutput(result=result.to_proto())

    async def get_average_budget_distribution(self, message: analytics_pb2.GetAverageBudgetDistribution):
        result = await procedures.GetAverageBudgetDistribution()(request=structs.GetAverageBudgetDistributionRequest.from_proto(message))
        return analytics_pb2.GetAverageBudgetDistributionOutput(result=result.to_proto())

    async def get_market_situation(self, message: analytics_pb2.GetMarketSituation):
        result = await procedures.GetMarketSituation()(request=structs.GetMarketSituationRequest.from_proto(message))
        return analytics_pb2.GetMarketSituationOutput(result=result.to_proto())

    async def get_active_clients(self, message: analytics_pb2.GetActiveClients):
        result = await procedures.GetActiveClients()(request=structs.GetActiveClientsRequest.from_proto(message))
        return analytics_pb2.GetActiveClientsOutput(result=result.to_proto())

    async def get_clients_increase(self, message: analytics_pb2.GetClientsIncrease):
        result = await procedures.GetClientsIncrease()(request=structs.GetClientsIncreaseRequest.from_proto(message))
        return analytics_pb2.GetClientsIncreaseOutput(result=result.to_proto())
