from dataclasses import dataclass

from crm.agency_cabinet.agencies.server.src.db import models
from crm.agency_cabinet.agencies.common import structs


@dataclass
class GetAgenciesInfo:
    async def __call__(self, request: structs.GetAgenciesInfoRequest) -> structs.GetAgenciesInfoResponse:
        agencies = await models.Agency.query.where(
            models.Agency.id.in_(request.agency_ids)
        ).gino.all()

        return structs.GetAgenciesInfoResponse(
            agencies=[structs.AgencyInfo(
                agency_id=agency.id,
                name=agency.name,
                phone=agency.phone,
                email=agency.email,
                site=agency.site,
                actual_address=agency.actual_address,
                legal_address=agency.legal_address
            ) for agency in agencies]
        )


@dataclass
class GetAllAgenciesInfo:
    async def __call__(self) -> structs.GetAgenciesInfoResponse:
        agencies = await models.Agency.query.gino.all()

        return structs.GetAgenciesInfoResponse(
            agencies=[structs.AgencyInfo(
                agency_id=agency.id,
                name=agency.name,
                phone=agency.phone,
                email=agency.email,
                site=agency.site,
                actual_address=agency.actual_address,
                legal_address=agency.legal_address
            ) for agency in agencies]
        )
