from dataclasses import dataclass
from sqlalchemy import or_
from crm.agency_cabinet.agencies.server.src.db import models
from crm.agency_cabinet.agencies.common import structs


class NoSuchClient(Exception):
    pass


class UnsuitableAgency(Exception):
    pass


@dataclass
class GetClientInfo:
    async def __call__(self, request: structs.GetClientInfoRequest) -> structs.GetClientInfoResponse:
        client = await models.Client.query.where(
            models.Client.id == request.client_id
        ).gino.first()
        if client is None:
            raise NoSuchClient

        if client.agency_id != request.agency_id:
            raise UnsuitableAgency

        return structs.GetClientInfoResponse(
            client=structs.ClientInfo(
                name=client.name,
                id=client.id,
                login=client.login
            )
        )


@dataclass
class GetClientsInfo:
    async def __call__(self, request: structs.GetClientsInfoRequest) -> structs.GetClientsInfoResponse:
        query = models.Client.query.where(
            models.Client.agency_id == request.agency_id
        )

        if request.search_query:
            query = query.where(
                or_(
                    models.Client.login.ilike(f'%{request.search_query.lower()}%'),
                    models.Client.name.ilike(f'%{request.search_query.lower()}%'),
                )
            )

        if request.limit:
            query = query.limit(request.limit)

        if request.offset:
            query = query.offset(request.offset)

        clients = await query.gino.all()

        return structs.GetClientsInfoResponse(
            clients=[structs.ClientInfo(
                name=client.name,
                id=client.id,
                login=client.login
            ) for client in clients]
        )
