PY3_LIBRARY()

OWNER(
    g:agency_cabinet_back
)

PEERDIR(
    contrib/python/alembic
    contrib/python/celery
    contrib/python/ipython
    crm/agency_cabinet/agencies/common
    crm/agency_cabinet/agencies/proto
    crm/agency_cabinet/common/celery
    crm/agency_cabinet/common/config
    crm/agency_cabinet/common/db
    crm/agency_cabinet/common/service_discovery
    crm/agency_cabinet/common/server/rpc
    crm/agency_cabinet/common/yql
    crm/agency_cabinet/common/yt
    crm/agency_cabinet/common/monitoring

    yql/library/python
)

PY_SRCS(
    src/config/__init__.py

    src/celery/tasks/__init__.py
    src/celery/tasks/load_agencies_info.py
    src/celery/tasks/load_client_info.py
    src/celery/tasks/load_client_analytics_data.py
    src/celery/__init__.py
    src/celery/base.py

    src/db/models/__init__.py
    src/db/models/agency.py
    src/db/models/contract.py
    src/db/models/client.py
    src/db/models/analytics.py
    src/db/__init__.py
    src/db/engine.py
    src/db/queries.py

    src/procedures/__init__.py
    src/procedures/agency_info.py
    src/procedures/clients.py
    src/procedures/analytics.py

    src/__init__.py
    src/handler.py
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(
    bin
    migrations
)
