from dataclasses import dataclass
from decimal import Decimal

from crm.agency_cabinet.certificates.proto import direct_details_pb2


@dataclass
class DirectKPI:
    name: str
    group: str
    value: Decimal
    max_value: Decimal

    @classmethod
    def from_proto(cls, data: direct_details_pb2.DirectKPI) -> "DirectKPI":
        return cls(
            name=data.name,
            group=data.group,
            value=Decimal(data.value),
            max_value=Decimal(data.max_value),
        )

    def to_proto(self) -> direct_details_pb2.DirectKPI:
        return direct_details_pb2.DirectKPI(
            name=self.name,
            group=self.group,
            value="{:f}".format(self.value.normalize()),
            max_value="{:f}".format(self.max_value.normalize()),
        )


@dataclass
class DirectBonusPoint:
    name: str
    value: str
    threshold: str
    score: Decimal
    is_met: bool

    @classmethod
    def from_proto(
        cls, data: direct_details_pb2.DirectBonusPoint
    ) -> "DirectBonusPoint":
        return cls(
            name=data.name,
            value=data.value,
            threshold=data.threshold,
            score=Decimal(data.score),
            is_met=data.is_met,
        )

    def to_proto(self) -> direct_details_pb2.DirectBonusPoint:
        return direct_details_pb2.DirectBonusPoint(
            name=self.name,
            value=self.value,
            threshold=self.threshold,
            score="{:f}".format(self.score.normalize()),
            is_met=self.is_met,
        )


@dataclass
class DirectCertificationCondition:
    name: str
    value: str
    threshold: str
    is_met: bool

    @classmethod
    def from_proto(
        cls, data: direct_details_pb2.DirectCertificationCondition
    ) -> "DirectCertificationCondition":
        return cls(
            name=data.name,
            value=data.value,
            threshold=data.threshold,
            is_met=data.is_met,
        )

    def to_proto(self) -> direct_details_pb2.DirectCertificationCondition:
        return direct_details_pb2.DirectCertificationCondition(
            name=self.name,
            value=self.value,
            threshold=self.threshold,
            is_met=self.is_met,
        )


@dataclass
class DirectCertificationScores:
    score_group: str
    value: Decimal
    threshold: Decimal
    is_met: bool

    @classmethod
    def from_proto(
        cls, data: direct_details_pb2.DirectScores
    ) -> "DirectCertificationScores":
        return cls(
            score_group=data.score_group,
            value=Decimal(data.value),
            threshold=Decimal(data.threshold),
            is_met=data.is_met,
        )

    def to_proto(self) -> direct_details_pb2.DirectScores:
        return direct_details_pb2.DirectScores(
            score_group=self.score_group,
            value="{:f}".format(self.value.normalize()),
            threshold="{:f}".format(self.threshold.normalize()),
            is_met=self.is_met,
        )
