from dataclasses import dataclass
from typing import Optional

from crm.agency_cabinet.certificates.proto import certificates_pb2, common_pb2


@dataclass
class Pagination:
    offset: int
    limit: int

    @classmethod
    def from_proto(cls, message: common_pb2.Pagination) -> "Pagination":
        return cls(limit=message.limit, offset=message.offset)

    def to_proto(self) -> common_pb2.Pagination:
        return common_pb2.Pagination(limit=self.limit, offset=self.offset)


@dataclass
class AgencyCertificateDetailsRequest:
    agency_id: int

    @classmethod
    def from_proto(
        cls, data: certificates_pb2.AgencyCertificateDetailsRequest
    ) -> "AgencyCertificateDetailsRequest":
        return cls(
            agency_id=data.agency_id,
        )

    def to_proto(self) -> certificates_pb2.AgencyCertificateDetailsRequest:
        return certificates_pb2.AgencyCertificateDetailsRequest(
            agency_id=self.agency_id,
        )


@dataclass
class FetchAgencyCertificatesHistoryRequest:
    agency_id: int
    project: Optional[str]
    pagination: Pagination

    @classmethod
    def from_proto(
        cls, data: certificates_pb2.FetchAgencyCertificatesHistoryRequest
    ) -> "FetchAgencyCertificatesHistoryRequest":
        return cls(
            agency_id=data.agency_id,
            project=data.project if data.HasField("project") else None,
            pagination=Pagination.from_proto(data.pagination),
        )

    def to_proto(self) -> certificates_pb2.FetchAgencyCertificatesHistoryRequest:
        return certificates_pb2.FetchAgencyCertificatesHistoryRequest(
            agency_id=self.agency_id,
            project=self.project,
            pagination=self.pagination.to_proto(),
        )


@dataclass
class ListEmployeesCertificatesRequest:
    agency_id: int
    pagination: Pagination
    project: Optional[str]
    search_query: Optional[str]
    status: Optional[str]

    @classmethod
    def from_proto(
        cls, data: certificates_pb2.ListEmployeesCertificatesRequest
    ) -> "ListEmployeesCertificatesRequest":
        return cls(
            agency_id=data.agency_id,
            pagination=Pagination.from_proto(data.pagination),
            project=data.project if data.HasField("project") else None,
            search_query=data.search_query if data.HasField("search_query") else None,
            status=data.status if data.HasField("status") else None,
        )

    def to_proto(self) -> certificates_pb2.ListEmployeesCertificatesRequest:
        return certificates_pb2.ListEmployeesCertificatesRequest(
            agency_id=self.agency_id,
            pagination=self.pagination.to_proto(),
            project=self.project,
            search_query=self.search_query,
            status=self.status,
        )
