import click

from crm.agency_cabinet.certificates.server.lib import run_server, upgrade_db
from crm.agency_cabinet.certificates.server.lib.celery import celery_app


@click.group()
def cli():
    pass


@cli.command("run_server")
def run_server_command():
    return run_server()


@cli.command("upgrade_db")
def upgrade_db_command():
    return upgrade_db()


@cli.command("shell")
def shell():
    from IPython import embed

    embed()


def main():
    cli()


@cli.command(
    "celery_beat",
    context_settings=dict(
        ignore_unknown_options=True,
    ),
)
@click.argument("celery_beat_args", nargs=-1, type=click.UNPROCESSED)
def celery_beat(celery_beat_args):
    return celery_app.start(['beat'] + list(celery_beat_args))


@cli.command(
    "celery_worker",
    context_settings=dict(
        ignore_unknown_options=True,
    ),
)
@click.argument("celery_worker_args", nargs=-1, type=click.UNPROCESSED)
def celery_worker(celery_worker_args):
    return celery_app.worker_main(argv=["worker"] + list(celery_worker_args))


if __name__ == "__main__":
    main()
