YQL = """
USE hahn;

$meta = (
    SELECT
    AGGREGATE_LIST(
        {
            "label": `label`,
            "max_score": CAST(`max_score` AS String),
            "value_type": `value_type`
        }
    ) AS meta_data

FROM hahn.`home/search-research/yateika/ga-399/sertificate/dash/values`
);

$details = (
    SELECT
        `agency_id` as agency_id,
        `result_score`,
        `min_score`,

        `agency_login`,
        `agency_name`,
        `agency_type`,
        `aggregator`,
        `country_name`,
        `end_date`,
        `is_sert`,
        `manager_name`,
        `revenue`,
        `rus_result`,
        `setevoe`,
        `town_name`,


        -- conditions
        `agency_active_clients_cnt` as agency_active_clients_value,
        `agency_needed_active_clients_cnt` as agency_active_clients_threshold,

        `agency_metrika_sert_spec` as agency_metrika_sert_spec_value,
        `min_sert_metrika` as agency_metrika_sert_spec_threshold,

        `agency_direct_sert_spec` as agency_direct_sert_spec_value,
        `agency_need_direct_cnt` as agency_direct_sert_spec_threshold,

        -- points, scores
        `agency_pdz` == 0 as pdz_value,
        "отсутствует" as pdz_threshold,
        `agency_pdz` as pdz_score, -- здесь уже лежит балл

        `media_act_revenue` as media_revenue_bonus_value,
        `needed_media` as media_revenue_bonus_threshold,
        0 as media_revenue_bonus_score,

        `agency_media_sert_spec` as agency_media_sert_value,
        1 as agency_media_sert_threshold,
        0 as agency_media_sert_score,

        "" as media_general_value,
        "" as media_general_threshold,
        `media_score` as media_general_score, -- балл общий для обоих показателей


        `agency_case_cnt` as agency_case_value,
        "1" as agency_case_threshold,
        `agency_case` as agency_case_score, -- баллы за рекламныне кейсы

        `general_curr`,
        `general_min`,
        `rsya_curr`,
        `rsya_min`,
        `search_curr`,
        `search_min`,

        -- KPIs
        `alive_client_rate_score` as alive_client_rate,
        `callout_banner_rate_score`as callout_banner_rate,
        `click_autostrategy_cid_rate_score`as click_autostrategy_cid_rate,
        `conver_autostrategy_cid_rate_score`as conver_autostrategy_cid_rate,
        `counter_cid_rate_score`as counter_cid_rate,
        `ctr_desktop_rate_score`as ctr_desktop_rate,
        `ctr_mobile_rate_score`as ctr_mobile_rate,
        `died_client_rate_score`as died_client_rate,
        `dynamic_client_rate_score`as dynamic_client_rate,
        `goal_cid_rate_score`as goal_cid_rate,
        `graph_client_rate_score`as graph_client_rate,
        `href_banner_rate_score`as href_banner_rate,
        `image_banner_rate_score`as image_banner_rate,
        `mcbanner_client_rate_score`as mcbanner_client_rate,
        `mobile_content_client_rate_score`as mobile_content_client_rate,
        `mobile_corr_pid_rate_score`as mobile_corr_pid_rate,
        `mobile_pid_rate_score`as mobile_pid_rate,
        `no_moderate_banner_rate_score`as no_moderate_banner_rate,
        `relevance_match_cid_rate_score`as relevance_match_cid_rate,
        `retarget_client_rate_score`as retarget_client_rate,
        `rsya_client_rate_score`as rsya_client_rate,
        `sitelink_banner_rate_score`as sitelink_banner_rate,
        `smart_banner_client_rate_score`as smart_banner_client_rate,
        `stop_client_rate_score`as stop_client_rate,
        `vcard_banner_rate_score`as vcard_banner_rate,
        `video_creative_pid_rate_score`as video_creative_pid_rate,
        `wide_image_pid_rate_score` as wide_image_pid_rate
    FROM hahn.`home/search-research/yateika/ga-399/sertificate/onepage/last`
);

SELECT * FROM $details AS details CROSS JOIN $meta AS meta;
"""
