from celery.schedules import crontab
from environs import Env

env = Env()

SQS_ENDPOINT = env("SQS_URL", "sqs.yandex.net:8771")

CELERY_SETTINGS = {
    "broker_url": (
        SQS_ENDPOINT
        if env.bool("USE_SQS", False)
        else env("BROKER_URL", "redis://localhost:6379")
    ),
    "result_expires": None,  # despite we don't use result_backend (i.e. DisabledBackend), celery beat generates
    "task_routes": {              # task to clean up dummy backend; remove if/when we use result_backend
        "crm.agency_cabinet.certificates.server.lib.celery.tasks.*": {
            "queue": "certificates"
        }
    },
    "imports": ['crm.agency_cabinet.common.celery.signals', 'crm.agency_cabinet.certificates.server.lib.celery.tasks'],
    "beat_schedule": {
        "load_employee_certificates_data": {
            "task": "crm.agency_cabinet.certificates.server.lib.celery.tasks.load_employee_certificates_data_task",
            "schedule": crontab(hour="10", minute="0"),  # UTC
            "options": {
                "queue": "certificates",
            },
        },
        "load_direct_details_certificate_data": {
            "task": "crm.agency_cabinet.certificates.server.lib.celery.tasks.load_direct_details_certificates_data_task",
            "schedule": crontab(hour="12", minute="50"),  # UTC
            "options": {
                "queue": "certificates",
            },
        },
    },
    "beat_scheduler": "crm.agency_cabinet.common.celery.scheduler.LockedPersistentScheduler",  # noqa
    "broker_transport_options": {"is_secure": False, "region": "yandex"},
}

SCHEDULER_LOCK_SETTINGS = {
    "proxy": env(
        "SCHEDULER_LOCK_PROXY", "freud"
    ),  # use Locke for prod after getting grants,
    'prefix': env('SCHEDULER_LOCK_PREFIX', 'tmp'),
    "token": env("YT_TOKEN", None),
    "lock_params": {
        "lock_key": env("SCHEDULER_LOCK_KEY", "celerybeat-lock"),  # + env?
        "next_try_timeout": 30,
    },
}

CERTIFICATES_LOADER_SETTINGS = {
    "yt_proxy": env("YT_PROXY", "hahn"),
    "yt_token": env("YT_TOKEN", None),
    "yt_timeout": env("YT_TIMEOUT", 60),
    "yql_token": env("YQL_TOKEN", None),
}
