**Структура данных**

`employee_certificates` - сертификация сотрудников рекламных агентств

`agency_certificates` - общая информация о сертификации агентств

`agency_certificates_direct_kpi` - KPI-баллы для сертификации агентств по Директу (отношение с таблицей сертификации агентств как много-к-одному)

`agency_certificates_direct_bonus_scores` - бонусные баллы для сертификации агентств по директу (отношение с таблицей сертификации агентств как много-к-одному)

`agency_certificates_conditions` - условия участия в сертификации агентств по Директу (отношение с таблицей сертификации агентств как много-к-одному)


**Источники данных по сертификации**

В общем случае данные по сертификации агентств и их сотрудников берутся из YT.

***Источник данных по сертификации сотрудников***

[Все данные про сертификаты сотрудников на YT](https://yt.yandex-team.ru/hahn/navigation?path=//home/search-research/yateika/help/cert)

Интересные нам поля:
- agency_id
- cert_id - внешний идентификатор сертификата
- due_date - дата и время истечения срока действия
- confirmed_date - дата и время выдачи
- user_login - префикс логина яндексового сотрудника
- user_name имя сотрудника
- is_* - набор полей (сейчас присутствуют is_direct, is_metrika, is_media), отражающие проект, по которому сертифицирован сотрудник.
Редьюсятся в наше поле project таблицы сертификации сотрудников.

Ответственная за выгрузку - [Катя Авилова](https://staff.yandex-team.ru/yateika).


***Источник общих данных по сертификации агентств***

[Ссылка на тикет](https://st.yandex-team.ru/FINPRO-277) - TBD

Ответственная за выгрузку - [Катя Авилова](https://staff.yandex-team.ru/yateika).


***Источник данных по детализации сертификации Директа***

[Основная таблица в YT](https://yt.yandex-team.ru/hahn/navigation?path=%252F%252Fhome%252Fsearch-research%252Fyateika%252Fga-399%252Fsertificate%252Fonepage%252Flast). Здесь вперемешку лежат KPI, бонусы (scores) и условия для участия в сертификации.

Столбцы с KPI можно определить по наличию одноименного значения в столбце `label` таблицы `values` (см [здесь](https://yt.yandex-team.ru/hahn/navigation?path=%252F%252Fhome%252Fsearch-research%252Fyateika%252Fga-399%252Fsertificate%252Fdash%252Fvalues)). Из столбца в этой таблице мы берем значение, которое потом положим в value нашей таблицы про kpi, max_value берем из той же таблицы `values` (см [здесь](https://yt.yandex-team.ru/hahn/navigation?path=%252F%252Fhome%252Fsearch-research%252Fyateika%252Fga-399%252Fsertificate%252Fdash%252Fvalues))..

К условиям участия относятся
- количество активных клиентов (столбец `agency_active_clients_cnt` - `agency_needed_active_clients_cnt` здесь лежит пороговое значение),
- количество сертифиированных специалистов по Метрике (`agency_metrika_sert_spec` - `min_sert_metrika`)
- количество сертифицированных специалистов по директу на 100 клиентов (`agency_direct_sert_spec` - `agency_need_direct_cnt`).
- Условие "наличие договора" никак не хранится у нас, так как само присутствие агентства в таблице уже свитедетельствует о наличии договора с ним.

Столбцы, относящиеся к бонусным баллам, лежат в полях с постфиксом `_rate` и `_rate_score`.
Поле `_rate` - это value таблицы баллов.
Поле `_rate_score` - это score таблицы баллов.

[Расшифровка части полей источника данных по сертификации директа и метаинформация](https://wiki.yandex-team.ru/users/yateika/process-sertifikacii/)

- `agency_active_clients_cnt` – число активных клиентов в агентстве
- `agency_case` – балл за кейсы у агентства
- `agency_direct_sert_spec` – число сертифицированных специалистов по Директу у агентства
- `agency_id` – ID агентства
- `agency_login` – логин агентства
- `agency_media_sert_spec` – число сертифицированных специалистов по медийной рекламе
- `agency_metrika_sert_spec` – число сертифицированных специалистов по Метрике
- `agency_name` – название агентства
- `agency_need_direct_cnt` – необходимое число сертифицированных специалистов по Директу
- `agency_needed_active_clients_cnt` – необходимое число активных клиентов
- `agency_pdz` – балл за финзадолженность
- `country_name` – название страны агентства
- `end_date` – последняя дата обновления таблицы
- `general_curr` – текущий балл по блоку “ Общее ”
- `general_min` – минимальный балл по блоку “Общее”
- `is_sert` – сертифицирован или нет (Bool)
- `manager_name` – фамилия и имя менеджера агентства
- `media_act_revenue` – актовый оборот по медийной рекламе
- `media_score` – балл по медийному обороту и сертификату
- `min_score` – минимальный пороговый балл для сертификации
- `min_sert_metrika` – минимальное число сертифицированных специалистов по Метрике
- `needed_media` – необходимый актовый оборот по медийке для балла по медийному обороту
- `result_score`– общее число баллов
- `revenue` – общий оборот по Директу
- `rsya_curr` – текущий балл по блоку “РСЯ”
- `rsya_min` – минимальный балл по блоку “РСЯ”
- `rus_result` – расширенный результат сертификации
- `search_curr` – текущий балл по блоку “Поиск”
- `search_min` – минимальный балл по блоку “ Поиск ”
- `town_name` – название города
- `Х_rate` – значение показателя
- `Х_rate_score` – балл за показатель

[Расшифрока KPI и информация про максимальные возможные баллы по ним](https://yt.yandex-team.ru/hahn/navigation?path=%252F%252Fhome%252Fsearch-research%252Fyateika%252Fga-399%252Fsertificate%252Fdash%252Fvalues)

Ответственная за выгрузку - [Катя Авилова](https://staff.yandex-team.ru/yateika).
