CREATE TABLE employee_certificates (
    id bigserial PRIMARY KEY,
    external_id varchar(256),
    employee_email varchar(256) NOT NULL,
    employee_name varchar(256),
    agency_id bigint NOT NULL,
    project varchar(256) NOT NULL,
    start_time timestamptz NOT NULL,
    expiration_time timestamptz NOT NULL,
    created_at timestamptz NOT NULL default NOW()
);
CREATE INDEX employee_certificates__agency_id_idx ON employee_certificates (agency_id);

CREATE TABLE agency_certificates (
    id bigserial PRIMARY KEY,
    external_id varchar(256),
    agency_id bigint NOT NULL,
    project varchar(256) NOT NULL,
    start_time timestamptz NOT NULL,
    expiration_time timestamptz NOT NULL,
    created_at timestamptz NOT NULL default NOW()
);
CREATE INDEX agency_certificates__agency_id ON agency_certificates (agency_id);

CREATE TABLE agency_certificates_direct_kpi (
    id bigserial PRIMARY KEY,
    agency_id bigint NOT NULL,
    name varchar(256) NOT NULL,
    group_name varchar(256) NOT NULL,
    value numeric(18, 6) NOT NULL,
    max_value numeric(18, 6) NOT NULL,
    created_at timestamptz NOT NULL default NOW()
);
CREATE INDEX agency_certificates_direct_kpi__agency_id ON agency_certificates_direct_kpi (agency_id);

CREATE TABLE agency_certificates_direct_bonus_scores(
    id bigserial PRIMARY KEY,
    agency_id bigint NOT NULL,
    name varchar(256) NOT NULL,
    score numeric(18, 6) NOT NULL,
    value varchar(256) NOT NULL,
    threshold varchar(256) NOT NULL,
    is_met boolean NOT NULL,
    created_at timestamptz NOT NULL default NOW()
);
CREATE INDEX agency_certificates_direct_scores__agency_id ON agency_certificates_direct_bonus_scores (agency_id);

CREATE TABLE agency_certificates_direct_conditions (
    id bigserial PRIMARY KEY,
    agency_id bigint NOT NULL,
    name varchar(256) NOT NULL,
    value varchar(256) NOT NULL,
    threshold varchar(256) NOT NULL,
    is_met boolean NOT NULL,
    created_at timestamptz NOT NULL default NOW()
);
CREATE INDEX agency_certificates_direct_conditions__agency_id ON agency_certificates_direct_conditions (agency_id);

CREATE TABLE agency_certificates_prolongation_score (
    id bigserial PRIMARY KEY,
    agency_id bigint NOT NULL,
    project varchar(256) NOT NULL,
    current_score numeric(18, 6) NOT NULL,
    target_score numeric(18, 6) NOT NULL,
    created_at timestamptz NOT NULL default NOW()
);
CREATE UNIQUE INDEX direct_prolongation_score_agency_id_project_idx
ON agency_certificates_prolongation_score (agency_id, project);
