PY3TEST()

OWNER(
    g:agency_cabinet_back
)

SIZE(LARGE)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

ENV(DATABASE_URL_FOR_TESTS=postgresql://certificates:certificates@localhost:5433/certificates)

PEERDIR(
    contrib/python/pytest-asyncio
    contrib/python/pytest-mock
    contrib/python/pytest-freezegun

    smb/common/multiruntime
    smb/common/pgswim/pytest
    smb/common/testing_utils

    crm/agency_cabinet/certificates/server
    crm/agency_cabinet/common/testing
)

PY_SRCS(
    __init__.py
    conftest.py
    factory.py
    celery/__init__.py
    celery/load_certificates_data/__init__.py
    celery/load_certificates_data/conftest.py
    celery/load_certificates_data/processors/__init__.py
    celery/load_certificates_data/synchronizers/__init__.py
    celery/load_certificates_data/loaders/__init__.py
    celery/load_certificates_data/processors/conftest.py
    handlers/__init__.py
    handlers/conftest.py
    procedures/__init__.py
)

TEST_SRCS(
    celery/load_certificates_data/synchronizers/test_employees_certificates_table_synchronizer.py
    celery/load_certificates_data/loaders/test_employee_certificates_loader.py
    celery/load_certificates_data/processors/test_agency_certificates_processor.py
    celery/load_certificates_data/processors/test_bonuses_processors.py
    celery/load_certificates_data/processors/test_conditions_processor.py
    celery/load_certificates_data/processors/test_kpi_processor.py
    celery/load_certificates_data/loaders/test_agency_direct_certification_details_loader.py
    celery/load_certificates_data/synchronizers/test_bonuses_synchronizer.py
    celery/load_certificates_data/synchronizers/test_kpi_synchronizer.py
    celery/load_certificates_data/synchronizers/test_conditions_synchronizer.py
    celery/load_certificates_data/synchronizers/test_agency_certificates_synchronizer.py
    handlers/test_fetch_agency_certificate_details.py
    handlers/test_fetch_agency_certificates_history.py
    handlers/test_list_agency_certificates.py
    handlers/test_list_employees_certificates.py
    procedures/test_fetch_agency_certificate_details.py
    procedures/test_fetch_agency_certificates_history.py
    procedures/test_list_agency_certificates.py
    procedures/test_list_emplyees_cerificates.py
)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

CONFTEST_LOAD_POLICY_LOCAL()

END()
