PY3_LIBRARY()

OWNER(
    g:agency_cabinet_back
)


PEERDIR(
    contrib/python/celery
    yql/library/python
    yt/python/client

    crm/agency_cabinet/common/celery
    crm/agency_cabinet/certificates/common
    crm/agency_cabinet/certificates/proto
    crm/agency_cabinet/common/config
    crm/agency_cabinet/common/server/rpc
    crm/agency_cabinet/common/service_discovery

    smb/common/helpers
    smb/common/multiruntime
    smb/common/pgswim
)


PY_SRCS(
    lib/celery/__init__.py
    lib/celery/base.py
    lib/celery/tasks/__init__.py
    lib/celery/tasks/load_certificates_data/__init__.py
    lib/celery/tasks/load_certificates_data/loaders.py
    lib/celery/tasks/load_certificates_data/synchronizers.py
    lib/celery/tasks/load_certificates_data/processors.py
    lib/celery/tasks/load_certificates_data/yql/agency_certificate_details.py
    lib/config/__init__.py
    lib/db/__init__.py
    lib/db/engine.py
    lib/__init__.py
    lib/handler.py
    lib/exceptions.py
    lib/procedures.py
)

RESOURCE_FILES(
    PREFIX crm/agency_cabinet/certificates/server

    lib/db/migrations/001/downgrade.sql
    lib/db/migrations/001/upgrade.sql

    lib/db/migrations/002/downgrade.sql
    lib/db/migrations/002/upgrade.sql
)

END()

RECURSE(bin)

RECURSE_FOR_TESTS(tests)
