from dataclasses import dataclass

from crm.agency_cabinet.common.client.exceptions import BaseClientException

__all__ = ["ClientBonusesClientException", "ClientNotFound", "NoSuchReportException", "UnsuitableAgencyException",
           "FileNotFoundException", "ReportNotReadyException"]


class ClientBonusesClientException(BaseClientException):
    pass


@dataclass
class ClientNotFound(ClientBonusesClientException):
    agency_id: int
    client_id: int


class NoSuchReportException(ClientBonusesClientException):
    pass


class UnsuitableAgencyException(ClientBonusesClientException):
    pass


class FileNotFoundException(ClientBonusesClientException):
    pass


class ReportNotReadyException(ClientBonusesClientException):
    pass
