from celery.schedules import crontab
from environs import Env

env = Env()

SQS_ENDPOINT = env("SQS_URL", "sqs.yandex.net:8771")

CELERY_SETTINGS = {
    "broker_url": SQS_ENDPOINT
    if env.bool("USE_SQS", False)
    else env("BROKER_URL", "redis://localhost:6379"),
    "result_expires": None,  # despite we don't use result_backend (i.e. DisabledBackend), celery beat generates
    "task_routes": {  # task to clean up dummy backend; remove if/when we use result_backend
        "crm.agency_cabinet.client_bonuses.server.lib.celery.tasks.*": {
            "queue": "client_bonuses"
        }
    },
    "imports": ['crm.agency_cabinet.common.celery.signals', 'crm.agency_cabinet.client_bonuses.server.lib.celery.tasks'],
    "beat_schedule": {
        "load_bonuses_to_activate_data": {
            "task": "crm.agency_cabinet.client_bonuses.server.lib.celery.tasks.load_bonuses_to_activate_data_task",
            "schedule": crontab(hour="2", minute="18"),  # UTC
            "options": {
                "queue": "client_bonuses",
            },
        },
        "generate_reports": {
            "task": "crm.agency_cabinet.client_bonuses.server.lib.celery.tasks.check_requested_reports_task",
            "schedule": env.float('CHECK_REPORTS_INTERVAL', 30),
            "options": {
                "queue": "client_bonuses",
            },
        },
        "load_cashback_programs": {
            "task": "crm.agency_cabinet.client_bonuses.server.lib.celery.tasks.load_cashback_programs_task",
            "schedule": crontab(hour="1", minute="37"),  # UTC
            "options": {
                "queue": "client_bonuses",
            },
        },
        'clear_faulty_in_progress_reports_task': {
            'task': 'crm.agency_cabinet.client_bonuses.server.lib.celery.tasks.clear_faulty_in_progress_reports_task',
            'schedule': env.float('CLEAR_REPORTS_INTERVAL', 60 * 30),
            'options': {
                'queue': 'client_bonuses_utils',
            },
            'kwargs': {
                'delta_hours': env.int('CHECK_IN_PROGRESS_REPORTS_DELTA_HOURS', 1)
            }
        },
        'clear_old_error_reports_task': {
            'task': 'crm.agency_cabinet.client_bonuses.server.lib.celery.tasks.clear_old_error_reports_task',
            'schedule': env.float('CLEAR_REPORTS_INTERVAL', 60 * 30),
            'options': {
                'queue': 'client_bonuses_utils',

            },
            'kwargs': {
                'delta_hours': env.int('CHECK_ERROR_REPORTS_DELTA_HOURS', 24 * 3)
            }
        }
    },
    "beat_scheduler": "crm.agency_cabinet.common.celery.scheduler.LockedPersistentScheduler",  # noqa
    "broker_transport_options": {
        "is_secure": False,
        "region": "yandex",
    },
}

SCHEDULER_LOCK_SETTINGS = {
    "proxy": env(
        "SCHEDULER_LOCK_PROXY", "freud"
    ),  # use Locke for prod after getting grants,
    'prefix': env('SCHEDULER_LOCK_PREFIX', 'tmp'),
    "token": env("YT_TOKEN", None),
    "lock_params": {
        "lock_key": env("SCHEDULER_LOCK_KEY", "celerybeat-lock"),  # + env?
        "next_try_timeout": 30,
    },
}

BONUSES_LOADER_SETTINGS = {
    "yt_proxy": env("YT_PROXY", "hahn"),
    "yt_token": env("YT_TOKEN", None),
    "yql_token": env("YQL_TOKEN", None),
}
