CREATE EXTENSION IF NOT EXISTS pg_trgm;

CREATE TABLE clients (
    id bigint PRIMARY KEY,
    login varchar(256) NOT NULL,
    agency_id bigint NOT NULL
);
CREATE INDEX clients__agency_id_idx ON clients (agency_id);
CREATE INDEX clients__login_idx ON clients USING gin (login gin_trgm_ops);


CREATE TABLE clients_programs (
    id bigserial NOT NULL,
    client_id bigint NOT NULL,
    program_code varchar(64) NOT NULL,
    CONSTRAINT clients_programs__pk PRIMARY KEY (id),
    CONSTRAINT clients_programs_client__client_id__fk FOREIGN KEY(client_id) REFERENCES clients (id),
    CONSTRAINT clients_programs__client_id__uq UNIQUE (client_id, program_code)
);
CREATE UNIQUE INDEX clients_programs__client_id_program_code_idx ON clients_programs
    USING btree (client_id, program_code);

CREATE TABLE gained_client_bonuses (
    id bigserial PRIMARY KEY,
    client_id bigint NOT NULL,
    gained_at timestamptz NOT NULL,
    program_code varchar(64) NOT NULL,
    amount numeric(18, 6) NOT NULL,
    CONSTRAINT gained_client_bonuses__non_negative__ck CHECK (amount >= 0.0),
    CONSTRAINT gained_client_bonuses_client__client_id__fk FOREIGN KEY(client_id) REFERENCES clients (id)
);
CREATE INDEX gained_client_bonuses__gained_at_client_id_idx ON gained_client_bonuses
    USING btree (gained_at, client_id);
CREATE INDEX gained_client_bonuses__client_id_gained_at_idx ON gained_client_bonuses
    USING btree (gained_at DESC, program_code ASC);

CREATE TABLE spent_client_bonuses (
    id bigserial PRIMARY KEY,
    client_id bigint NOT NULL,
    spent_at timestamptz NOT NULL,
    amount numeric(18, 6) NOT NULL,
    CONSTRAINT spent_client_bonuses__non_negative__ck CHECK (amount >= 0.0),
    CONSTRAINT spent_client_bonuses_client__client_id__fk FOREIGN KEY(client_id) REFERENCES clients (id)
);
CREATE UNIQUE INDEX spent_client_bonuses__client_id_spent_at ON spent_client_bonuses
    USING btree (client_id ASC, spent_at DESC);
CREATE INDEX spent_client_bonuses__spent_at_client_id_idx ON spent_client_bonuses
    USING btree (spent_at, client_id);

CREATE TABLE client_bonuses_to_activate (
    id bigserial PRIMARY KEY,
    client_id bigint NOT NULL,
    amount numeric(18, 6) NOT NULL,
    CONSTRAINT client_bonuses_to_activate__non_negative__ck CHECK (amount >= 0.0),
    CONSTRAINT client_bonuses_to_activate_client__client_id__fk FOREIGN KEY(client_id) REFERENCES clients (id),
    CONSTRAINT client_bonuses_to_activate__client_id__uq UNIQUE (client_id)
);
CREATE UNIQUE INDEX client_bonus_to_activate__client_id_idx ON client_bonuses_to_activate
    USING btree (client_id);
